/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.modelobserver;

import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EContentAdapter;
import org.palladiosimulator.analyzer.workflow.core.blackboard.PCMResourceSetPartition;
import org.palladiosimulator.simulizar.core.utils.PCMPartitionManager;
import org.palladiosimulator.simulizar.modelobserver.IModelObserver;

public abstract class AbstractModelObserver<T extends EObject>
implements IModelObserver {
    protected static final Logger LOGGER = Logger.getLogger(AbstractModelObserver.class);
    protected Collection<T> model;
    private EContentAdapter adapter;
    protected final PCMResourceSetPartition globalPCMInstance;

    protected AbstractModelObserver(@PCMPartitionManager.Global PCMResourceSetPartition globalPCMInstance) {
        this.globalPCMInstance = globalPCMInstance;
    }

    protected abstract Stream<T> selectObservees(PCMResourceSetPartition var1);

    @Override
    public void initialize() {
        this.model = this.selectObservees(this.globalPCMInstance).collect(Collectors.toList());
        this.adapter = new EContentAdapter(){

            public void notifyChanged(Notification notification) {
                super.notifyChanged(notification);
                if (notification.getEventType() != 8 && notification.getEventType() != 9) {
                    LOGGER.debug((Object)(String.valueOf(((Object)((Object)this)).getClass().getName()) + " detected change - Resync simulation entities: " + notification));
                    AbstractModelObserver.this.notifyModelObservers(notification);
                }
            }
        };
        this.model.forEach(m -> {
            boolean bl = m.eAdapters().add((Object)this.adapter);
        });
    }

    @Override
    public void unregister() {
        if (this.adapter != null) {
            this.model.forEach(m -> {
                boolean bl = m.eAdapters().remove((Object)this.adapter);
            });
        }
    }

    private void notifyModelObservers(Notification notification) {
        switch (notification.getEventType()) {
            case 3: {
                this.add(notification);
                break;
            }
            case 4: {
                this.remove(notification);
                break;
            }
            case 1: {
                this.set(notification);
                break;
            }
            case 7: {
                this.move(notification);
                break;
            }
            case 5: {
                this.addMany(notification);
                break;
            }
            case 10: {
                this.eventTypeCount(notification);
                break;
            }
            case -1: {
                this.noFeatureID(notification);
                break;
            }
            case 6: {
                this.removeMany(notification);
                break;
            }
            case 8: {
                this.removingAdapter(notification);
                break;
            }
            case 9: {
                this.resolve(notification);
                break;
            }
            case 2: {
                this.unset(notification);
                break;
            }
            case 1000: {
                this.applyProfile(notification);
                break;
            }
            case 1001: {
                this.unapplyProfile(notification);
                break;
            }
            case 1002: {
                this.applyStereotype(notification);
                break;
            }
            case 1003: {
                this.unapplyStereotype(notification);
                break;
            }
            case 1004: {
                this.setTaggedValue(notification);
                break;
            }
            default: {
                throw new RuntimeException("Ignoring notification with event type \"" + notification.getEventType() + "\"");
            }
        }
    }

    protected void unset(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void resolve(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void removingAdapter(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void removeMany(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void noFeatureID(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void eventTypeCount(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void addMany(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void add(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void remove(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void set(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void move(Notification notification) {
        this.logDebugInfo(notification);
    }

    private void unapplyStereotype(Notification notification) {
        this.logDebugInfo(notification);
    }

    private void applyStereotype(Notification notification) {
        this.logDebugInfo(notification);
    }

    private void unapplyProfile(Notification notification) {
        this.logDebugInfo(notification);
    }

    private void applyProfile(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void setTaggedValue(Notification notification) {
        this.logDebugInfo(notification);
    }

    protected void logDebugInfo(Notification notification) {
        if (LOGGER.isDebugEnabled()) {
            StringBuilder message = new StringBuilder();
            message.append("Ignoring notification with event type \"");
            message.append(notification.getEventType());
            message.append("\"");
            LOGGER.debug((Object)message.toString());
        }
    }
}

