/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.simulizar.runtimestate;

import de.uka.ipd.sdq.identifier.Identifier;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.core.entity.NamedElement;

public class FQComponentID {
    public static final String SEPARATOR = "::";
    private final List<AssemblyContext> assembyContextPath;

    public FQComponentID(List<AssemblyContext> assemblyContextPath) {
        this.assembyContextPath = Collections.unmodifiableList(assemblyContextPath);
    }

    public final List<AssemblyContext> getAssembyContextPath() {
        return this.assembyContextPath;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        for (AssemblyContext ctx : this.assembyContextPath) {
            result = 31 * result + ctx.getId().hashCode();
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FQComponentID other = (FQComponentID)obj;
        if (this.assembyContextPath == null) {
            if (other.assembyContextPath != null) {
                return false;
            }
        } else {
            if (this.assembyContextPath.size() != other.assembyContextPath.size()) {
                return false;
            }
            int i = 0;
            while (i < this.assembyContextPath.size()) {
                if (!this.assembyContextPath.get(i).getId().equals(other.assembyContextPath.get(i).getId())) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    public String getFQIDString() {
        return this.assembyContextPath.stream().map(Identifier::getId).collect(Collectors.joining(SEPARATOR));
    }

    public String toString() {
        return this.assembyContextPath.stream().map(NamedElement::getEntityName).collect(Collectors.joining(SEPARATOR, "FQComponentID [assembyContextPath=", "]"));
    }
}

