/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.monitor.calculator;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.palladiosimulator.analyzer.slingshot.monitor.observer.EventBasedMeasurementObserver;
import org.palladiosimulator.analyzer.slingshot.monitor.recorder.decorator.MonitoringAttachingCalculatorFactoryDecorator;
import org.palladiosimulator.analyzer.slingshot.monitor.recorder.decorator.RecorderAttachingCalculatorFactoryDecorator;
import org.palladiosimulator.probeframework.calculator.ExtensibleCalculatorFactoryDelegatingFactory;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.calculator.RegisterCalculatorFactoryDecorator;

@Singleton
public class CalculatorFactoryProvider
implements Provider<IGenericCalculatorFactory> {
    private final SimuComConfig simuComConfig;
    private final EventBasedMeasurementObserver observer;
    private final IGenericCalculatorFactory factory;

    @Inject
    public CalculatorFactoryProvider(SimuComConfig simuComConfig, EventBasedMeasurementObserver observer) {
        this.simuComConfig = simuComConfig;
        this.observer = observer;
        ExtensibleCalculatorFactoryDelegatingFactory parentFactory = new ExtensibleCalculatorFactoryDelegatingFactory();
        RecorderAttachingCalculatorFactoryDecorator recorderAttachedFactory = new RecorderAttachingCalculatorFactoryDecorator((IGenericCalculatorFactory)parentFactory, simuComConfig.getRecorderName(), simuComConfig.getRecorderConfigurationFactory());
        MonitoringAttachingCalculatorFactoryDecorator monitorAttachedFactory = new MonitoringAttachingCalculatorFactoryDecorator(recorderAttachedFactory, this.observer);
        RegisterCalculatorFactoryDecorator registeringFactory = new RegisterCalculatorFactoryDecorator((IGenericCalculatorFactory)monitorAttachedFactory);
        this.factory = registeringFactory;
    }

    public IGenericCalculatorFactory get() {
        return this.factory;
    }
}

