/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.monitor.recorder.decorator;

import java.util.HashMap;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.measurementframework.listener.IMeasurementSourceListener;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.CalculatorProbeSet;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.recorderframework.IRecorder;
import org.palladiosimulator.recorderframework.config.IRecorderConfiguration;
import org.palladiosimulator.recorderframework.config.IRecorderConfigurationFactory;
import org.palladiosimulator.recorderframework.utils.RecorderExtensionHelper;

public class RecorderAttachingCalculatorFactoryDecorator
implements IGenericCalculatorFactory {
    private final IGenericCalculatorFactory delegator;
    private final String recorderName;
    private final IRecorderConfigurationFactory configurationFactory;

    public RecorderAttachingCalculatorFactoryDecorator(IGenericCalculatorFactory delegator, String recorderName, IRecorderConfigurationFactory configurationFactory) {
        this.delegator = delegator;
        this.recorderName = recorderName;
        this.configurationFactory = configurationFactory;
    }

    public Calculator buildCalculator(MetricDescription arg0, MeasuringPoint arg1, CalculatorProbeSet arg2) {
        return this.setupCalculator(this.delegator.buildCalculator(arg0, arg1, arg2));
    }

    private Calculator setupCalculator(Calculator calculator) {
        HashMap<String, Object> recorderConfigurationMap = new HashMap<String, Object>(2);
        recorderConfigurationMap.put("recorderAcceptedMetric", calculator.getMetricDesciption());
        recorderConfigurationMap.put("measuringPoint", calculator.getMeasuringPoint());
        IRecorder recorder = RecorderExtensionHelper.instantiateRecorderImplementationForRecorder((String)this.recorderName);
        IRecorderConfiguration recorderConfiguration = this.configurationFactory.createRecorderConfiguration(recorderConfigurationMap);
        recorder.initialize(recorderConfiguration);
        calculator.addObserver((IMeasurementSourceListener)recorder);
        return calculator;
    }
}

