/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource;

import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.Optional;
import java.util.UUID;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.GeneralEntryRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.usagemodel.entities.User;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.Signature;

public final class CallOverWireRequest {
    private final String id;
    private final AssemblyContext from;
    private final AssemblyContext to;
    private final Signature signature;
    private final User user;
    private final GeneralEntryRequest entryRequest;
    private final SimulatedStackframe<Object> variablesToConsider;
    private final Optional<CallOverWireRequest> replyTo;

    public CallOverWireRequest(Builder builder) {
        this.from = builder.from;
        this.to = builder.to;
        this.signature = builder.signature;
        this.user = builder.user;
        this.id = UUID.randomUUID().toString();
        this.entryRequest = builder.entryRequest;
        this.replyTo = Optional.ofNullable(builder.replyTo);
        this.variablesToConsider = builder.variablesToConsider;
    }

    public String getId() {
        return this.id;
    }

    public SimulatedStackframe<Object> getVariablesToConsider() {
        return this.variablesToConsider;
    }

    public AssemblyContext getFrom() {
        return this.from;
    }

    public AssemblyContext getTo() {
        return this.to;
    }

    public Signature getSignature() {
        return this.signature;
    }

    public User getUser() {
        return this.user;
    }

    public GeneralEntryRequest getEntryRequest() {
        return this.entryRequest;
    }

    public Optional<CallOverWireRequest> getReplyTo() {
        return this.replyTo;
    }

    public CallOverWireRequest createReplyRequest(SimulatedStackframe<Object> returnStackframe) {
        return CallOverWireRequest.builder().from(this.from).to(this.to).entryRequest(this.entryRequest).signature(this.signature).user(this.user).replyTo(this).variablesToConsider(returnStackframe).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private AssemblyContext from;
        private AssemblyContext to;
        private Signature signature;
        private User user;
        private GeneralEntryRequest entryRequest;
        private CallOverWireRequest replyTo;
        private SimulatedStackframe<Object> variablesToConsider;

        private Builder() {
        }

        public Builder from(AssemblyContext from) {
            this.from = from;
            return this;
        }

        public Builder to(AssemblyContext to) {
            this.to = to;
            return this;
        }

        public Builder signature(Signature signature) {
            this.signature = signature;
            return this;
        }

        public Builder user(User user) {
            this.user = user;
            return this;
        }

        public Builder entryRequest(GeneralEntryRequest entryRequest) {
            this.entryRequest = entryRequest;
            return this;
        }

        public Builder replyTo(CallOverWireRequest replyTo) {
            this.replyTo = replyTo;
            return this;
        }

        public Builder variablesToConsider(SimulatedStackframe<Object> variablesToConsider) {
            this.variablesToConsider = variablesToConsider;
            return this;
        }

        public CallOverWireRequest build() {
            return new CallOverWireRequest(this);
        }
    }
}

