/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.usageevolution;

import de.uka.ipd.sdq.simucomframework.SimuComConfig;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.events.IntervalPassed;
import org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver.AbstractUsageEvolver;
import org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver.LoopingUsageEvolver;
import org.palladiosimulator.analyzer.slingshot.behavior.usageevolution.evolver.StretchedUsageEvolver;
import org.palladiosimulator.analyzer.slingshot.common.annotations.Nullable;
import org.palladiosimulator.analyzer.slingshot.core.events.PreSimulationConfigurationStarted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.scaledl.usageevolution.Usage;
import org.scaledl.usageevolution.UsageEvolution;

@OnEvent.OnEvents(value={@OnEvent(when=IntervalPassed.class, then={IntervalPassed.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=PreSimulationConfigurationStarted.class, then={IntervalPassed.class}, cardinality=EventCardinality.MANY)})
public class UsageEvolutionBehavior
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(UsageEvolutionBehavior.class);
    private final UsageEvolution usageEvolutionModel;
    private final Map<Usage, AbstractUsageEvolver> usage2evolver;
    private final Optional<Double> maxDuration;

    @Inject
    public UsageEvolutionBehavior(@Nullable UsageEvolution usageEvolutionModel, SimuComConfig config) {
        this.usageEvolutionModel = usageEvolutionModel;
        this.usage2evolver = new HashMap<Usage, AbstractUsageEvolver>();
        this.maxDuration = config.getSimuTime() > 0L ? Optional.of(Double.valueOf(config.getSimuTime())) : Optional.empty();
    }

    public boolean isActive() {
        return this.usageEvolutionModel != null && !this.usageEvolutionModel.getUsages().isEmpty();
    }

    @Subscribe
    public Result<IntervalPassed> onPreSimulationConfigurationStarted(PreSimulationConfigurationStarted preSimulationConfigurationStarted) {
        HashSet<IntervalPassed> events = new HashSet<IntervalPassed>();
        for (Usage usage : this.usageEvolutionModel.getUsages()) {
            AbstractUsageEvolver evolver = usage.isRepeatingPattern() ? new LoopingUsageEvolver(usage) : new StretchedUsageEvolver(usage, this.maxDuration);
            this.usage2evolver.put(usage, evolver);
            events.add(new IntervalPassed(0.0, usage));
        }
        return Result.of(events);
    }

    @Subscribe
    public Result<?> onIntervalPassed(IntervalPassed intervalPassed) {
        Usage usage = intervalPassed.getUsage();
        AbstractUsageEvolver evolver = this.usage2evolver.get(usage);
        evolver.triggerInternal(intervalPassed.time());
        return Result.of((Object[])new IntervalPassed[]{new IntervalPassed(usage.getEvolutionStepWidth(), usage)});
    }
}

