/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToTransformationExecutor;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.TransformationParameterInformation;

public class QVToModelTransformation {
    private static final Predicate<TransformationParameterInformation> PURE_OUT_PARAM_PREDICATE = transformationParameterInformation -> transformationParameterInformation.isOutParameter();
    private static final Predicate<TransformationParameterInformation> IN_INOUT_PARAM_PREDICATE = Predicate.not(PURE_OUT_PARAM_PREDICATE);
    private final QVToTransformationExecutor transformationExecutor;
    private final Collection<TransformationParameterInformation> inParams;
    private final Collection<TransformationParameterInformation> outParams;
    private final OperationalTransformation modelTransformation;

    public QVToModelTransformation(OperationalTransformation transformation, QVToTransformationExecutor executor, Collection<TransformationParameterInformation> paramInfo) {
        this.modelTransformation = transformation;
        this.transformationExecutor = executor;
        this.inParams = paramInfo.stream().filter(IN_INOUT_PARAM_PREDICATE).collect(Collectors.toUnmodifiableList());
        this.outParams = paramInfo.stream().filter(PURE_OUT_PARAM_PREDICATE).collect(Collectors.toUnmodifiableList());
    }

    public int getParameterCount() {
        return this.inParams.size() + this.outParams.size();
    }

    public Collection<TransformationParameterInformation> getPureOutParameters() {
        return this.outParams;
    }

    public Collection<TransformationParameterInformation> getInParameters() {
        return this.inParams;
    }

    public String getTransformationName() {
        return this.modelTransformation.getName();
    }

    public QVToTransformationExecutor getTransformationExecutor() {
        return this.transformationExecutor;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("QVToTransformation[name = ");
        builder.append(this.modelTransformation.getName());
        builder.append(", params = {\n");
        this.inParams.forEach(inf -> {
            builder.append("\t[");
            builder.append(inf.toString());
            builder.append("]\n");
        });
        this.outParams.forEach(inf -> {
            builder.append("\t[");
            builder.append(inf.toString());
            builder.append("]\n");
        });
        builder.append("}1]");
        return builder.toString();
    }
}

