/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator;

import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.AbstractWindowAggregation;

public class SlidingTimeWindowAggregationBasedOnEMA
extends AbstractWindowAggregation {
    private double windowSizeInSeconds;
    private double currentValue;
    private double emitTime;
    private final double durationNoEmit;
    private double alpha;
    private double lastUpdateTime;

    public SlidingTimeWindowAggregationBasedOnEMA(int winSizeSeconds, double noEmitDuration, double smoothingFactor) {
        this.windowSizeInSeconds = winSizeSeconds;
        this.durationNoEmit = noEmitDuration;
        this.emitTime = 0.0;
        this.alpha = smoothingFactor;
        this.currentValue = 0.0;
        this.lastUpdateTime = 0.0;
    }

    @Override
    public double aggregate(double currentTime, double newValue) {
        double deltaTime = currentTime - this.lastUpdateTime;
        this.currentValue = (1.0 - this.alpha) * this.currentValue + this.alpha * newValue;
        double timeFactor = Math.exp(-deltaTime / this.windowSizeInSeconds);
        this.currentValue *= timeFactor;
        this.lastUpdateTime = currentTime;
        return this.currentValue;
    }

    public double getCurrentAggregate() {
        return this.currentValue;
    }

    @Override
    public boolean isEmittable() {
        return this.lastUpdateTime > this.windowSizeInSeconds && this.lastUpdateTime - this.emitTime > this.durationNoEmit;
    }

    @Override
    protected double getCurrentVal() {
        assert (this.lastUpdateTime - this.emitTime > this.durationNoEmit);
        this.emitTime = this.lastUpdateTime;
        return this.currentValue;
    }
}

