/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint;

import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint.AbstractConstraintFilter;
import org.palladiosimulator.spd.constraints.policy.CooldownConstraint;

public class CooldownConstraintFilter
extends AbstractConstraintFilter<CooldownConstraint> {
    public CooldownConstraintFilter(CooldownConstraint constraint) {
        super(constraint);
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper event) {
        int numberScalesInCooldown = event.getState().getNumberOfScalesInCooldown();
        double cooldownEnd = event.getState().getCoolDownEnd();
        if (event.getEventToFilter().time() >= cooldownEnd) {
            return FilterResult.success(event.getEventToFilter());
        }
        if (numberScalesInCooldown < ((CooldownConstraint)this.constraint).getMaxScalingOperations()) {
            return FilterResult.success(event.getEventToFilter());
        }
        return FilterResult.disregard(String.format("Max number scales reached: %d >= %d", numberScalesInCooldown, ((CooldownConstraint)this.constraint).getMaxScalingOperations()));
    }
}

