/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger;

import java.util.Set;
import javax.measure.Measure;
import javax.measure.unit.SI;
import javax.measure.unit.Unit;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.ComparatorResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.TriggerChecker;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.SlingshotMeasuringValue;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.MeasurementMade;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcmmeasuringpoint.OperationReference;
import org.palladiosimulator.spd.triggers.BaseTrigger;
import org.palladiosimulator.spd.triggers.SimpleFireOnValue;
import org.palladiosimulator.spd.triggers.expectations.ExpectedTime;
import org.palladiosimulator.spd.triggers.stimuli.OperationResponseTime;

public final class OperationResponseTimeTriggerChecker
extends TriggerChecker<OperationResponseTime> {
    public OperationResponseTimeTriggerChecker(SimpleFireOnValue trigger) {
        super((BaseTrigger)trigger, OperationResponseTime.class, Set.of(ExpectedTime.class));
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper objectWrapper) {
        DESEvent event = objectWrapper.getEventToFilter();
        if (event instanceof MeasurementMade var3_4) {
            SlingshotMeasuringValue measuringValue = (SlingshotMeasuringValue)measurementMade.getEntity();
            MeasuringPoint point = measuringValue.getMeasuringPoint();
            if (point instanceof OperationReference var7_8) {
                OperationSignature referencedSignature = reference.getOperationSignature();
                OperationSignature thisSignature = ((OperationResponseTime)this.getStimulus()).getOperationSignature();
                if (thisSignature.getId().equals(referencedSignature.getId())) {
                    Measure measure = measuringValue.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.RESPONSE_TIME_METRIC);
                    double operationTime = measure.doubleValue((Unit)SI.SECOND);
                    if (this.compareToTrigger(operationTime) == ComparatorResult.IN_ACCORDANCE) {
                        return FilterResult.success(event);
                    }
                    return FilterResult.disregard("Conditions for trigger " + this.trigger.getId() + " are not met.");
                }
                return FilterResult.disregard("Expected signature " + thisSignature.getEntityName() + " but received " + referencedSignature.getEntityName());
            }
            return FilterResult.disregard("Expected measuringpoint of type " + OperationReference.class.getSimpleName() + ", but received measuringpoint of type " + point.getClass().getSimpleName());
        }
        return FilterResult.disregard("Expected measurement made event, but received " + event.getClass().getSimpleName());
    }
}

