/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs;

import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.Job;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;

public class ActiveJob
extends Job {
    private final ProcessingResourceType processingResourceType;
    private final AllocationContext allocationContext;
    private final ResourceDemandRequest request;

    private ActiveJob(Builder builder) {
        super(builder.id, builder.demand);
        this.processingResourceType = builder.processingResourceType;
        this.allocationContext = builder.allocationContext;
        this.request = builder.request;
    }

    public ProcessingResourceType getProcessingResourceType() {
        return this.processingResourceType;
    }

    public ResourceDemandRequest getRequest() {
        return this.request;
    }

    public AllocationContext getAllocationContext() {
        return this.allocationContext;
    }

    public ProcessingResourceSpecification getProcessingResourceSpecification() {
        List matches = this.allocationContext.getResourceContainer_AllocationContext().getActiveResourceSpecifications_ResourceContainer().stream().filter(spec -> spec.getActiveResourceType_ActiveResourceSpecification().equals(this.processingResourceType)).collect(Collectors.toList());
        if (matches.size() != 1) {
            throw new IllegalArgumentException(String.format("Wrong number of matching ProcessingResourceSpecifications, expected 1 but found %d", matches.size()));
        }
        return (ProcessingResourceSpecification)matches.get(0);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String id;
        private double demand;
        private ProcessingResourceType processingResourceType;
        private AllocationContext allocationContext;
        private ResourceDemandRequest request;

        private Builder() {
        }

        public Builder withId(String id) {
            this.id = id;
            return this;
        }

        public Builder withDemand(double demand) {
            this.demand = demand;
            return this;
        }

        public Builder withProcessingResourceType(ProcessingResourceType processingResourceType) {
            this.processingResourceType = processingResourceType;
            return this;
        }

        public Builder withAllocationContext(AllocationContext allocationContext) {
            this.allocationContext = allocationContext;
            return this;
        }

        public Builder withRequest(ResourceDemandRequest request) {
            this.request = request;
            return this;
        }

        public ActiveJob build() {
            return new ActiveJob(this);
        }
    }
}

