/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs;

import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.pcm.repository.PassiveResource;

public final class WaitingJob {
    private final ResourceDemandRequest request;
    private final PassiveResource passiveResource;
    private final long demand;

    private WaitingJob(Builder builder) {
        this.request = builder.request;
        this.passiveResource = builder.passiveResource;
        this.demand = builder.demand;
    }

    public ResourceDemandRequest getRequest() {
        return this.request;
    }

    public PassiveResource getPassiveResource() {
        return this.passiveResource;
    }

    public long getDemand() {
        return this.demand;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ResourceDemandRequest request;
        private PassiveResource passiveResource;
        private long demand;

        private Builder() {
        }

        public Builder withRequest(ResourceDemandRequest request) {
            this.request = request;
            return this;
        }

        public Builder withPassiveResource(PassiveResource passiveResource) {
            this.passiveResource = passiveResource;
            return this;
        }

        public Builder withDemand(long demand) {
            this.demand = demand;
            return this;
        }

        public WaitingJob build() {
            return new WaitingJob(this);
        }
    }
}

