/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ResourceDemandCalculated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor.ActiveResourceProbeTable;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ActiveResourceStateUpdated.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ResourceDemandCalculated.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class ActiveResourceMonitorBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final ActiveResourceProbeTable table = new ActiveResourceProbeTable();

    @Inject
    public ActiveResourceMonitorBehavior(IGenericCalculatorFactory calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecification(MeasurementSpecificationVisited m) {
        MeasurementSpecification spec = (MeasurementSpecification)m.getEntity();
        MeasuringPoint measuringPoint = spec.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof ActiveResourceMeasuringPoint) {
            ActiveResourceMeasuringPoint activeResourceMeasuringPoint = (ActiveResourceMeasuringPoint)measuringPoint;
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC)) {
                Calculator calculator = this.table.setupStateOfActiveResourceCalculator(activeResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.RESOURCE_DEMAND_METRIC)) {
                Calculator calculator = this.table.setupResourceDemandCalculator(activeResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE)) {
                Calculator calculator = this.table.setupUtilizationOfActiveResourceCalculator(activeResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onResourceDemandCalculated(ResourceDemandCalculated stateUpdated) {
        Optional<Probe> probe = this.table.currentResourceDemand(stateUpdated);
        if (probe.isPresent()) {
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe.get()).build())});
        }
        return Result.of((Object[])new ProbeTaken[0]);
    }

    @Subscribe
    public Result<ProbeTaken> onActiveResourceStateUpdated(ActiveResourceStateUpdated stateUpdated) {
        Set<Probe> probes = this.table.currentStateAndUtilizationOfActiveResource(stateUpdated);
        Set probesTaken = probes.stream().map(probe -> new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe).build())).collect(Collectors.toSet());
        return Result.of(probesTaken);
    }
}

