/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor;

import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.PassiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor.PassiveResourceProbeTable;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceAcquired;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceReleased;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequested;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ResourceDemandRequested.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=PassiveResourceAcquired.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=PassiveResourceReleased.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=PassiveResourceStateUpdated.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class PassiveResourceMonitoringBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final PassiveResourceProbeTable table = new PassiveResourceProbeTable();

    @Inject
    public PassiveResourceMonitoringBehavior(IGenericCalculatorFactory calculatorFactory) {
        this.calculatorFactory = calculatorFactory;
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecification(MeasurementSpecificationVisited m) {
        MeasurementSpecification spec = (MeasurementSpecification)m.getEntity();
        MeasuringPoint measuringPoint = spec.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof AssemblyPassiveResourceMeasuringPoint) {
            AssemblyPassiveResourceMeasuringPoint passiveResourceMeasuringPoint = (AssemblyPassiveResourceMeasuringPoint)measuringPoint;
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC)) {
                Calculator calculator = this.table.setupWaitingTimeCalculator(passiveResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC)) {
                Calculator calculator = this.table.setupHoldingTimeCalculator(passiveResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC)) {
                Calculator calculator = this.table.setupStateOfPassiveResourceCalculator(passiveResourceMeasuringPoint, this.calculatorFactory);
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onResourceDemandRequest(ResourceDemandRequested resourceDemandRequest) {
        if (((ResourceDemandRequest)resourceDemandRequest.getEntity()).getResourceType() == ResourceDemandRequest.ResourceType.PASSIVE) {
            Probe probe = this.table.currentTimeOfPassiveResourceRequested(resourceDemandRequest);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe).build())});
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onPassiveResourceAcquired(PassiveResourceAcquired passiveResourceAcquired) {
        if (((ResourceDemandRequest)passiveResourceAcquired.getEntity()).getResourceType() == ResourceDemandRequest.ResourceType.PASSIVE) {
            Probe probe = this.table.currentTimeOfPassiveResourceAcquired(passiveResourceAcquired);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe).build())});
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onPassiveResourceReleased(PassiveResourceReleased passiveResourceReleased) {
        if (((ResourceDemandRequest)passiveResourceReleased.getEntity()).getResourceType() == ResourceDemandRequest.ResourceType.PASSIVE) {
            Probe probe = this.table.currentTimeOfPassiveResourceReleased(passiveResourceReleased);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe).build())});
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onPassiveResourceStateUpdated(PassiveResourceStateUpdated stateUpdated) {
        if (((ResourceDemandRequest)stateUpdated.getEntity()).getResourceType() == ResourceDemandRequest.ResourceType.PASSIVE) {
            Probe probe = this.table.stateOfPassiveResourceUpdated(stateUpdated);
            return Result.of((Object[])new ProbeTaken[]{new ProbeTaken(ProbeTakenEntity.builder().withProbe(probe).build())});
        }
        return Result.empty();
    }
}

