/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor;

import java.util.HashMap;
import java.util.Map;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.PassiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.probes.StateOfPassiveResourceProbe;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceAcquired;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceReleased;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequested;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.monitor.utils.probes.EventCurrentSimulationTimeProbe;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyPassiveResourceMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.measurement.RequestContext;
import org.palladiosimulator.probeframework.probes.Probe;

public final class PassiveResourceProbeTable {
    private final Map<String, Probes> probes = new HashMap<String, Probes>();

    public void addPassiveResource(PassiveResource passiveResource) {
        this.probes.putIfAbsent(passiveResource.getId(), new Probes());
    }

    public Probe currentTimeOfPassiveResourceRequested(ResourceDemandRequested requested) {
        PassiveResource passiveResource = (PassiveResource)((ResourceDemandRequest)requested.getEntity()).getPassiveResource().orElseThrow();
        Probes probes = this.probes.get(passiveResource.getId());
        if (probes != null) {
            probes.resourceDemandRequestedProbe.takeMeasurement((DESEvent)requested);
            return probes.resourceDemandRequestedProbe;
        }
        return null;
    }

    public Probe currentTimeOfPassiveResourceAcquired(PassiveResourceAcquired passiveResourceAcquired) {
        PassiveResource passiveResource = (PassiveResource)((ResourceDemandRequest)passiveResourceAcquired.getEntity()).getPassiveResource().orElseThrow();
        Probes probes = this.probes.get(passiveResource.getId());
        if (probes != null) {
            probes.passiveResourceAcquiredProbe.takeMeasurement((DESEvent)passiveResourceAcquired);
            return probes.passiveResourceAcquiredProbe;
        }
        return null;
    }

    public Probe currentTimeOfPassiveResourceReleased(PassiveResourceReleased passiveResourceReleased) {
        PassiveResource passiveResource = (PassiveResource)((ResourceDemandRequest)passiveResourceReleased.getEntity()).getPassiveResource().orElseThrow();
        Probes probes = this.probes.get(passiveResource.getId());
        if (probes != null) {
            probes.passiveResourceReleasedProbe.takeMeasurement((DESEvent)passiveResourceReleased);
            return probes.passiveResourceAcquiredProbe;
        }
        return null;
    }

    public Probe stateOfPassiveResourceUpdated(PassiveResourceStateUpdated passiveResourceStateUpdated) {
        PassiveResource passiveResource = (PassiveResource)((ResourceDemandRequest)passiveResourceStateUpdated.getEntity()).getPassiveResource().orElseThrow();
        Probes probes = this.probes.get(passiveResource.getId());
        if (probes != null) {
            probes.passiveResourceStateProbe.takeMeasurement((DESEvent)passiveResourceStateUpdated);
            return probes.passiveResourceStateProbe;
        }
        return null;
    }

    public Calculator setupWaitingTimeCalculator(AssemblyPassiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addPassiveResource(measuringPoint.getPassiveResource());
        Probes probes = this.probes.get(measuringPoint.getPassiveResource().getId());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.WAITING_TIME_METRIC_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration((Probe)probes.resourceDemandRequestedProbe, (Probe)probes.passiveResourceAcquiredProbe));
    }

    public Calculator setupHoldingTimeCalculator(AssemblyPassiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addPassiveResource(measuringPoint.getPassiveResource());
        Probes probes = this.probes.get(measuringPoint.getPassiveResource().getId());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.HOLDING_TIME_METRIC_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createStartStopProbeConfiguration((Probe)probes.passiveResourceAcquiredProbe, (Probe)probes.passiveResourceReleasedProbe));
    }

    public Calculator setupStateOfPassiveResourceCalculator(AssemblyPassiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addPassiveResource(measuringPoint.getPassiveResource());
        Probes probes = this.probes.get(measuringPoint.getPassiveResource().getId());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.STATE_OF_PASSIVE_RESOURCE_METRIC_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probes.passiveResourceStateProbe));
    }

    private static final class Probes {
        private final EventCurrentSimulationTimeProbe resourceDemandRequestedProbe = new EventCurrentSimulationTimeProbe(t -> new RequestContext(((ResourceDemandRequest)((ResourceDemandRequested)t).getEntity()).getSeffInterpretationContext().getRequestProcessingContext().getUserId()));
        private final EventCurrentSimulationTimeProbe passiveResourceAcquiredProbe = new EventCurrentSimulationTimeProbe(t -> new RequestContext(((ResourceDemandRequest)((PassiveResourceAcquired)t).getEntity()).getSeffInterpretationContext().getRequestProcessingContext().getUserId()));
        private final EventCurrentSimulationTimeProbe passiveResourceReleasedProbe = new EventCurrentSimulationTimeProbe(t -> new RequestContext(((ResourceDemandRequest)((PassiveResourceReleased)t).getEntity()).getSeffInterpretationContext().getRequestProcessingContext().getUserId()));
        private final StateOfPassiveResourceProbe passiveResourceStateProbe = new StateOfPassiveResourceProbe();

        private Probes() {
        }
    }
}

