/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.ActiveJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ResourceDemandCalculated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.probes.ResourceDemandRequestedProbe;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.probes.StateOfActiveResourceProbe;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.probes.UtilizationOfActiveResourceProbe;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;

public final class ActiveResourceProbeTable {
    private final Map<ProcessingResourceSpecification, Probes> probes = new HashMap<ProcessingResourceSpecification, Probes>();

    public void addActiveResource(ProcessingResourceSpecification spec) {
        this.probes.putIfAbsent(spec, new Probes());
    }

    public Set<Probe> currentStateAndUtilizationOfActiveResource(ActiveResourceStateUpdated event) {
        ActiveJob activeJob;
        Probes probes;
        if (event.getEntity() instanceof ActiveJob && (probes = this.probes.get((activeJob = (ActiveJob)event.getEntity()).getProcessingResourceSpecification())) != null) {
            probes.stateOfActiveResourceProbe.takeMeasurement((DESEvent)event);
            probes.utilizationOfActiveResourceProbe.takeMeasurement((DESEvent)event);
            return Set.of(probes.stateOfActiveResourceProbe, probes.utilizationOfActiveResourceProbe);
        }
        return Set.of();
    }

    public Optional<Probe> currentResourceDemand(ResourceDemandCalculated event) {
        ActiveJob activeJob;
        Probes probes;
        if (event.getEntity() instanceof ActiveJob && (probes = this.probes.get((activeJob = (ActiveJob)event.getEntity()).getProcessingResourceSpecification())) != null) {
            probes.resourceDemandProbe.takeMeasurement((DESEvent)event);
            return Optional.of(probes.resourceDemandProbe);
        }
        return Optional.empty();
    }

    public Calculator setupStateOfActiveResourceCalculator(ActiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addActiveResource(measuringPoint.getActiveResource());
        Probes probes = this.probes.get(measuringPoint.getActiveResource());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.STATE_OF_ACTIVE_RESOURCE_METRIC_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probes.stateOfActiveResourceProbe));
    }

    public Calculator setupUtilizationOfActiveResourceCalculator(ActiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addActiveResource(measuringPoint.getActiveResource());
        Probes probes = this.probes.get(measuringPoint.getActiveResource());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.UTILIZATION_OF_ACTIVE_RESOURCE_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probes.utilizationOfActiveResourceProbe));
    }

    public Calculator setupResourceDemandCalculator(ActiveResourceMeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory) {
        this.addActiveResource(measuringPoint.getActiveResource());
        Probes probes = this.probes.get(measuringPoint.getActiveResource());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.RESOURCE_DEMAND_METRIC_TUPLE, (MeasuringPoint)measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probes.resourceDemandProbe));
    }

    private static final class Probes {
        private final StateOfActiveResourceProbe stateOfActiveResourceProbe = new StateOfActiveResourceProbe();
        private final UtilizationOfActiveResourceProbe utilizationOfActiveResourceProbe = new UtilizationOfActiveResourceProbe();
        private final ResourceDemandRequestedProbe resourceDemandProbe = new ResourceDemandRequestedProbe();

        private Probes() {
        }
    }
}

