/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.monitor;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import javax.inject.Inject;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.probes.NumberOfElementsInElasitcInfrastuctureProbe;
import org.palladiosimulator.analyzer.slingshot.common.annotations.Nullable;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ModelAdjusted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.ProbeTakenEntity;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.CalculatorRegistered;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.ProbeTaken;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MeasurementSpecificationVisited;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.modelvisited.MonitorModelVisited;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.util.MetricDescriptionUtility;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.probeframework.calculator.Calculator;
import org.palladiosimulator.probeframework.calculator.DefaultCalculatorProbeSets;
import org.palladiosimulator.probeframework.calculator.IGenericCalculatorFactory;
import org.palladiosimulator.probeframework.probes.Probe;
import org.palladiosimulator.semanticspd.Configuration;
import org.palladiosimulator.semanticspd.ElasticInfrastructureCfg;
import org.palladiosimulator.spdmeasuringpoint.ElasticInfrastructureMeasuringPoint;

@OnEvent.OnEvents(value={@OnEvent(when=MonitorModelVisited.class, then={CalculatorRegistered.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ModelAdjusted.class, then={ProbeTaken.class}, cardinality=EventCardinality.SINGLE)})
public class NumberOfElementsMonitorBehavior
implements SimulationBehaviorExtension {
    private final IGenericCalculatorFactory calculatorFactory;
    private final Configuration semanticConfiguration;
    private final Map<ResourceContainer, NumberOfElementsInElasitcInfrastuctureProbe> probes = new HashMap<ResourceContainer, NumberOfElementsInElasitcInfrastuctureProbe>();

    @Inject
    public NumberOfElementsMonitorBehavior(IGenericCalculatorFactory calculatorFactory, @Nullable Configuration semanticConfiguration) {
        this.calculatorFactory = calculatorFactory;
        this.semanticConfiguration = semanticConfiguration;
    }

    public boolean isActive() {
        return this.semanticConfiguration != null && !this.semanticConfiguration.getTargetCfgs().isEmpty();
    }

    @Subscribe
    public Result<CalculatorRegistered> onMeasurementSpecification(MeasurementSpecificationVisited m) {
        MeasurementSpecification spec = (MeasurementSpecification)m.getEntity();
        MeasuringPoint measuringPoint = spec.getMonitor().getMeasuringPoint();
        if (measuringPoint instanceof ElasticInfrastructureMeasuringPoint) {
            Optional<ElasticInfrastructureCfg> serviceGroupCfg;
            ElasticInfrastructureMeasuringPoint resourceContainerMeasuringPoint = (ElasticInfrastructureMeasuringPoint)measuringPoint;
            if (MetricDescriptionUtility.metricDescriptionIdsEqual((MetricDescription)spec.getMetricDescription(), (MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS) && (serviceGroupCfg = this.semanticConfiguration.getTargetCfgs().stream().filter(cfg -> cfg instanceof ElasticInfrastructureCfg).map(eicfg -> (ElasticInfrastructureCfg)eicfg).filter(eicfg -> eicfg.getUnit().getId().equals(resourceContainerMeasuringPoint.getElasticInfrastructure().getUnit().getId())).findAny()).isPresent()) {
                Calculator calculator = this.setupNumberOfElementsCalculator((MeasuringPoint)resourceContainerMeasuringPoint, this.calculatorFactory, serviceGroupCfg.get());
                return Result.of((Object[])new CalculatorRegistered[]{new CalculatorRegistered(calculator)});
            }
        }
        return Result.empty();
    }

    @Subscribe
    public Result<ProbeTaken> onModelAdjusted(ModelAdjusted stateUpdated) {
        HashSet<ProbeTaken> probesTaken = new HashSet<ProbeTaken>();
        for (NumberOfElementsInElasitcInfrastuctureProbe probe : this.probes.values()) {
            probe.takeMeasurement((DESEvent)stateUpdated);
            probesTaken.add(new ProbeTaken(ProbeTakenEntity.builder().withProbe((Probe)probe).build()));
        }
        return Result.of(probesTaken);
    }

    public Calculator setupNumberOfElementsCalculator(MeasuringPoint measuringPoint, IGenericCalculatorFactory calculatorFactory, ElasticInfrastructureCfg eiCfg) {
        this.probes.putIfAbsent(eiCfg.getUnit(), new NumberOfElementsInElasitcInfrastuctureProbe(eiCfg));
        NumberOfElementsInElasitcInfrastuctureProbe probe = this.probes.get(eiCfg.getUnit());
        return calculatorFactory.buildCalculator((MetricDescription)MetricDescriptionConstants.NUMBER_OF_RESOURCE_CONTAINERS_OVER_TIME, measuringPoint, DefaultCalculatorProbeSets.createSingularProbeConfiguration((Probe)probe));
    }
}

