/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.linking;

import java.util.List;
import java.util.stream.Collectors;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.AbstractResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.linking.SimulatedLinkingResource;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;

public class LinkingResourceTable
extends AbstractResourceTable<String, SimulatedLinkingResource> {
    public void buildTable(Allocation allocation) {
        allocation.getTargetResourceEnvironment_Allocation().getLinkingResources__ResourceEnvironment().forEach(this::createSimulatedLinkingResource);
    }

    public void createSimulatedLinkingResource(LinkingResource linkingResource) {
        this.resources.put(linkingResource.getId(), new SimulatedLinkingResource(linkingResource));
    }

    public List<SimulatedLinkingResource> findLinkingResourceBetweenContainers(ResourceContainer from, ResourceContainer to) {
        return this.resources.values().stream().filter(lk -> this.isConnectedBy(from, to, lk.getLinkingResource())).collect(Collectors.toList());
    }

    public List<SimulatedLinkingResource> findLinkingResourceWithAtLeastOneContainer(ResourceContainer from, ResourceContainer to) {
        return this.resources.values().stream().filter(lk -> this.isConnectedByEitherOne(from, to, lk.getLinkingResource())).collect(Collectors.toList());
    }

    private boolean isConnectedByEitherOne(ResourceContainer from, ResourceContainer to, LinkingResource linkingResource) {
        return this.containerInLinkingResource(from, linkingResource) || this.containerInLinkingResource(to, linkingResource);
    }

    private boolean isConnectedBy(ResourceContainer from, ResourceContainer to, LinkingResource linkingResource) {
        return this.containerInLinkingResource(from, linkingResource) && this.containerInLinkingResource(to, linkingResource);
    }

    private boolean containerInLinkingResource(ResourceContainer rc, LinkingResource linkingResource) {
        return linkingResource.getConnectedResourceContainers_LinkingResource().stream().anyMatch(r -> r.getId().equals(rc.getId()));
    }
}

