/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.Optional;
import java.util.Set;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.Job;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.ProcessingRate;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.AbstractJobEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.AbstractActiveResource;

public class FCFSResource
extends AbstractActiveResource {
    private final Deque<Job> processes = new ArrayDeque<Job>();
    private double internalTimer;

    public FCFSResource(Object type, String name, long capacity, ProcessingRate rate) {
        super(type, name, capacity, rate);
    }

    @Override
    protected Optional<AbstractJobEvent> process(JobInitiated jobInitiated) {
        Job newJob = (Job)jobInitiated.getEntity();
        this.processes.add(newJob);
        if (this.processes.size() != 1) {
            return Optional.empty();
        }
        return this.scheduleNextEvent().map(j -> j);
    }

    @Override
    public Set<AbstractJobEvent> process(JobProgressed jobProgressed) {
        Job job = (Job)jobProgressed.getEntity();
        this.processes.remove(job);
        Optional<JobProgressed> next = this.scheduleNextEvent();
        if (next.isPresent()) {
            return Set.of(new JobFinished(job), (AbstractJobEvent)next.get());
        }
        return Set.of(new JobFinished(job));
    }

    public void clearJobs() {
        this.processes.clear();
    }

    @Override
    public void abortJob(Job job) {
        this.processes.remove(job);
    }

    @Deprecated
    private void updateInternalTimer(double simulationTime) {
        Job firstJob;
        double passedTime = simulationTime - this.internalTimer;
        if (MathTools.less((double)0.0, (double)passedTime) && (firstJob = this.processes.peek()) != null) {
            double demand = firstJob.getDemand() - passedTime;
            demand = MathTools.equalsDouble((double)demand, (double)0.0) ? 0.0 : demand;
            firstJob.updateDemand(demand);
        }
        this.internalTimer = simulationTime;
    }

    private Optional<JobProgressed> scheduleNextEvent() {
        if (this.processes.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(new JobProgressed(this.processes.peek(), this.processes.peek().getDemand()));
    }

    @Override
    protected ActiveResourceStateUpdated publishState(Job job) {
        int waitingJobs = this.processes.size();
        double utilization = !this.processes.isEmpty() ? 1 : 0;
        return new ActiveResourceStateUpdated(job, (long)waitingJobs, utilization);
    }
}

