/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import java.util.List;
import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.IPassiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.IPassiveResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.AbstractResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.PassiveResourceCompoundKey;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.SimplePassiveResource;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.BasicComponent;
import org.palladiosimulator.pcm.repository.PassiveResource;

public final class PassiveResourceTable
extends AbstractResourceTable<PassiveResourceCompoundKey, SimplePassiveResource>
implements IPassiveResourceTable {
    public void buildTable(Allocation allocation) {
        allocation.getAllocationContexts_Allocation().stream().map(AllocationContext::getAssemblyContext_AllocationContext).filter(allocationContext -> allocationContext.getEncapsulatedComponent__AssemblyContext() instanceof BasicComponent).forEach(this::createPassiveResources);
    }

    private void createPassiveResources(AssemblyContext assemblyContext) {
        assert (assemblyContext.getEncapsulatedComponent__AssemblyContext() instanceof BasicComponent);
        BasicComponent component = (BasicComponent)assemblyContext.getEncapsulatedComponent__AssemblyContext();
        component.getPassiveResource_BasicComponent().forEach(passiveResource -> {
            long capacity = (Long)StackContext.evaluateStatic((String)passiveResource.getCapacity_PassiveResource().getSpecification(), Long.class);
            PassiveResourceCompoundKey id = new PassiveResourceCompoundKey((PassiveResource)passiveResource, assemblyContext);
            this.resources.put(id, new SimplePassiveResource(id, capacity));
        });
    }

    public boolean isEmpty() {
        return this.resources.isEmpty();
    }

    public Optional<SimplePassiveResource> getPassiveResource(PassiveResourceCompoundKey id) {
        if (!this.resources.containsKey(id)) {
            return Optional.empty();
        }
        return Optional.of((SimplePassiveResource)this.resources.get(id));
    }

    public Optional<? extends IPassiveResource> getPassiveResourceFromModelElement(PassiveResource passiveResource, AssemblyContext assemblyContext) {
        PassiveResourceCompoundKey key = PassiveResourceCompoundKey.of(passiveResource, assemblyContext);
        return this.getPassiveResource(key);
    }

    public void buildPassiveResources(List<AllocationContext> newAllocations) {
        newAllocations.stream().map(AllocationContext::getAssemblyContext_AllocationContext).filter(allocationContext -> allocationContext.getEncapsulatedComponent__AssemblyContext() instanceof BasicComponent).forEach(this::createPassiveResources);
    }
}

