/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active;

import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.ActiveJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.Job;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.ProcessingRate;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.AbstractJobEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ResourceDemandCalculated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.AbstractResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResourceCompoundKey;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public abstract class AbstractActiveResource
extends AbstractResource
implements ActiveResource {
    private static final Logger LOGGER = Logger.getLogger(AbstractActiveResource.class);
    private final ProcessingRate processingRate;

    public AbstractActiveResource(Object id, String name, long capacity, ProcessingRate rate) {
        super(capacity, name, id);
        this.processingRate = rate;
    }

    protected abstract Optional<AbstractJobEvent> process(JobInitiated var1);

    protected abstract Set<AbstractJobEvent> process(JobProgressed var1);

    protected abstract ActiveResourceStateUpdated publishState(Job var1);

    protected abstract void abortJob(Job var1);

    @Override
    public boolean jobBelongsToResource(Job job) {
        if (job instanceof ActiveJob) {
            ActiveJob activeJob = (ActiveJob)job;
            ActiveResourceCompoundKey jobId = ActiveResourceCompoundKey.of(activeJob.getAllocationContext().getResourceContainer_AllocationContext(), (ResourceType)activeJob.getProcessingResourceType());
            return this.getId().equals(jobId);
        }
        return false;
    }

    @Override
    public Set<AbstractJobEvent> onJobInitiated(JobInitiated jobInitiated) {
        if (!this.jobBelongsToResource((Job)jobInitiated.getEntity())) {
            return Set.of();
        }
        double calculatedDemand = ((Job)jobInitiated.getEntity()).getDemand() / (Double)this.processingRate.calculateRV();
        ((Job)jobInitiated.getEntity()).updateDemand(calculatedDemand);
        Optional<AbstractJobEvent> event = this.process(jobInitiated);
        HashSet<ResourceDemandCalculated> resultEvents = new HashSet<ResourceDemandCalculated>(Set.of(this.publishState((Job)jobInitiated.getEntity()), new ResourceDemandCalculated((Job)jobInitiated.getEntity(), calculatedDemand)));
        if (event.isPresent()) {
            resultEvents.add((ResourceDemandCalculated)event.get());
        }
        return resultEvents;
    }

    @Override
    public Set<AbstractJobEvent> onJobProgressed(JobProgressed jobProgressed) {
        if (!this.jobBelongsToResource((Job)jobProgressed.getEntity())) {
            return Set.of();
        }
        HashSet<AbstractJobEvent> resultEvents = new HashSet<AbstractJobEvent>(this.process(jobProgressed));
        resultEvents.add((AbstractJobEvent)this.publishState((Job)jobProgressed.getEntity()));
        return resultEvents;
    }
}

