/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active;

import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.ProcessingRate;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.AbstractResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.AbstractActiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResourceCompoundKey;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.FCFSResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ProcessorSharingResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.SchedulingPolicyId;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ProcessingResourceType;
import org.palladiosimulator.pcm.resourcetype.ResourceType;
import org.palladiosimulator.pcm.resourcetype.SchedulingPolicy;

public final class ActiveResourceTable
extends AbstractResourceTable<ActiveResourceCompoundKey, ActiveResource> {
    public void createNewResource(ResourceContainer container, ProcessingResourceSpecification spec) {
        AbstractActiveResource resource;
        int numberOfReplicas = spec.getNumberOfReplicas();
        SchedulingPolicy schedulingPolicy = spec.getSchedulingPolicy();
        ActiveResourceCompoundKey id = this.getKey(container, spec);
        switch (SchedulingPolicyId.retrieveFromSchedulingPolicy(schedulingPolicy)) {
            case FCFS: {
                String resourceName = "FCFS".toString();
                resource = new FCFSResource(id, resourceName, numberOfReplicas, new ProcessingRate(spec.getProcessingRate_ProcessingResourceSpecification()));
                break;
            }
            case PROCESSOR_SHARING: {
                String resourceName = "PROCESSOR_SHARING".toString();
                resource = new ProcessorSharingResource(id, resourceName, (long)numberOfReplicas, new ProcessingRate(spec.getProcessingRate_ProcessingResourceSpecification()));
                break;
            }
            default: {
                resource = null;
                String resourceName = "";
            }
        }
        if (resource != null) {
            this.resources.put(id, resource);
        }
    }

    public void buildModel(Allocation allocation) {
        allocation.getAllocationContexts_Allocation().stream().map(AllocationContext::getResourceContainer_AllocationContext).forEach(this::createActiveResourcesFromResourceContainer);
    }

    public void createActiveResourcesFromResourceContainer(ResourceContainer resourceContainer) {
        resourceContainer.getActiveResourceSpecifications_ResourceContainer().forEach(spec -> this.createNewResource(resourceContainer, (ProcessingResourceSpecification)spec));
    }

    public void removeActiveResources(ResourceContainer resourceContainer) {
        resourceContainer.getActiveResourceSpecifications_ResourceContainer().stream().map(spec -> this.getKey(resourceContainer, (ProcessingResourceSpecification)spec)).filter(id -> this.resources.containsKey(id)).forEach(id -> {
            Object v = this.resources.remove(id);
        });
    }

    public ActiveResourceCompoundKey getKey(ResourceContainer container, ProcessingResourceSpecification spec) {
        ProcessingResourceType activeResourceType = spec.getActiveResourceType_ActiveResourceSpecification();
        return new ActiveResourceCompoundKey(container, (ResourceType)activeResourceType);
    }

    public Optional<ActiveResource> getActiveResource(ActiveResourceCompoundKey id) {
        if (!this.resources.containsKey(id)) {
            return Optional.empty();
        }
        return Optional.of((ActiveResource)this.resources.get(id));
    }
}

