/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation;

import de.uka.ipd.sdq.simucomframework.variables.StackContext;
import de.uka.ipd.sdq.simucomframework.variables.converter.NumberConverter;
import de.uka.ipd.sdq.simucomframework.variables.stackframe.SimulatedStackframe;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.ActiveJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.Job;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.LinkingJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.WaitingJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.AbstractJobEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.PassiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ResourceDemandCalculated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.repository.ResourceEnvironmentAccessor;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResourceCompoundKey;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.linking.LinkingResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.linking.SimulatedLinkingResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.PassiveResourceCompoundKey;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.PassiveResourceTable;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.SimplePassiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.CallOverWireRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.entities.resource.ResourceDemandRequest;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.AbstractResourceRequestEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ActiveResourceFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.CallOverWireSucceeded;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceAcquired;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceReleased;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequestAborted;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.ResourceDemandRequested;
import org.palladiosimulator.analyzer.slingshot.common.events.AbstractSimulationEvent;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.AllocationChange;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ModelAdjusted;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ResourceEnvironmentChange;
import org.palladiosimulator.analyzer.slingshot.core.events.SimulationFinished;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;
import org.palladiosimulator.pcm.resourceenvironment.LinkingResource;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

@OnEvent.OnEvents(value={@OnEvent(when=SimulationFinished.class, then={}), @OnEvent(when=JobInitiated.class, then={JobProgressed.class, ActiveResourceStateUpdated.class, ResourceDemandCalculated.class, JobAborted.class}, cardinality=EventCardinality.MANY), @OnEvent(when=JobProgressed.class, then={AbstractJobEvent.class, ActiveResourceStateUpdated.class, ResourceDemandCalculated.class, JobAborted.class}, cardinality=EventCardinality.MANY), @OnEvent(when=JobFinished.class, then={ActiveResourceFinished.class, CallOverWireSucceeded.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=PassiveResourceReleased.class, then={PassiveResourceAcquired.class}, cardinality=EventCardinality.MANY), @OnEvent(when=ResourceDemandRequested.class, then={JobInitiated.class, PassiveResourceAcquired.class, JobAborted.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=ModelAdjusted.class, then={}), @OnEvent(when=CallOverWireRequested.class, then={JobInitiated.class, CallOverWireSucceeded.class}, cardinality=EventCardinality.SINGLE), @OnEvent(when=JobAborted.class, then={CallOverWireAborted.class, ResourceDemandRequestAborted.class}, cardinality=EventCardinality.SINGLE)})
public class ResourceSimulation
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(ResourceSimulation.class);
    private final Allocation allocation;
    private final ResourceEnvironmentAccessor resourceEnvironmentAccessor;
    private final ActiveResourceTable resourceTable;
    private final PassiveResourceTable passiveResourceTable;
    private final LinkingResourceTable linkingResourceTable;

    @Inject
    public ResourceSimulation(Allocation allocation) {
        this.allocation = allocation;
        this.resourceEnvironmentAccessor = new ResourceEnvironmentAccessor(allocation);
        this.resourceTable = new ActiveResourceTable();
        this.passiveResourceTable = new PassiveResourceTable();
        this.linkingResourceTable = new LinkingResourceTable();
        this.init();
    }

    public void init() {
        this.resourceTable.buildModel(this.allocation);
        this.passiveResourceTable.buildTable(this.allocation);
        this.linkingResourceTable.buildTable(this.allocation);
    }

    @Subscribe
    public Result<AbstractSimulationEvent> onResourceDemandRequested(ResourceDemandRequested resourceDemandRequested) {
        ResourceDemandRequest request = (ResourceDemandRequest)resourceDemandRequested.getEntity();
        if (request.getResourceType() == ResourceDemandRequest.ResourceType.ACTIVE) {
            return Result.of(this.initiateActiveResource(request));
        }
        return Result.of(this.initiatePassiveResource(request));
    }

    private Set<AbstractResourceRequestEvent> initiatePassiveResource(ResourceDemandRequest request) {
        AssemblyContext assemblyContext;
        PassiveResource passiveResource = (PassiveResource)request.getPassiveResource().get();
        Optional<SimplePassiveResource> passiveResourceInstance = this.passiveResourceTable.getPassiveResource(PassiveResourceCompoundKey.of(passiveResource, assemblyContext = request.getAssemblyContext()));
        if (passiveResourceInstance.isPresent()) {
            WaitingJob waitingJob = this.createWaitingJob(request, passiveResource);
            Optional<PassiveResourceAcquired> aquired = passiveResourceInstance.get().acquire(waitingJob);
            if (aquired.isPresent()) {
                return Set.of((AbstractResourceRequestEvent)aquired.get(), new PassiveResourceStateUpdated(request, passiveResourceInstance.get().getCurrentlyAvailable()));
            }
        }
        return Set.of();
    }

    private Set<AbstractSimulationEvent> initiateActiveResource(ResourceDemandRequest request) {
        double demand = (Double)StackContext.evaluateStatic((String)request.getParametricResourceDemand().getSpecification_ParametericResourceDemand().getSpecification(), Double.class, (SimulatedStackframe)request.getUser().getStack().currentStackFrame());
        Optional<AllocationContext> context = this.allocation.getAllocationContexts_Allocation().stream().filter(c -> c.getAssemblyContext_AllocationContext().getId().equals(request.getAssemblyContext().getId())).findFirst();
        if (context.isEmpty()) {
            ActiveJob job = ActiveJob.builder().withDemand(demand).withId(UUID.randomUUID().toString()).withProcessingResourceType(request.getParametricResourceDemand().getRequiredResource_ParametricResourceDemand()).withRequest(request).build();
            return Set.of(new JobAborted((Job)job, 0.0));
        }
        ActiveJob job = ActiveJob.builder().withDemand(demand).withId(UUID.randomUUID().toString()).withProcessingResourceType(request.getParametricResourceDemand().getRequiredResource_ParametricResourceDemand()).withRequest(request).withAllocationContext(context.get()).build();
        return Set.of(new JobInitiated((Job)job, 0.0));
    }

    private WaitingJob createWaitingJob(ResourceDemandRequest request, PassiveResource passiveResource) {
        long demand = (Long)StackContext.evaluateStatic((String)request.getParametricResourceDemand().getSpecification_ParametericResourceDemand().getSpecification(), Long.class, (SimulatedStackframe)request.getUser().getStack().currentStackFrame());
        WaitingJob waitingJob = WaitingJob.builder().withPassiveResource(passiveResource).withRequest(request).withDemand(demand).build();
        return waitingJob;
    }

    @Subscribe
    public Result<AbstractJobEvent> onJobInitiated(JobInitiated jobInitiated) {
        Job job = (Job)jobInitiated.getEntity();
        if (job instanceof ActiveJob) {
            ActiveJob activeJob = (ActiveJob)job;
            ActiveResourceCompoundKey id = new ActiveResourceCompoundKey(activeJob.getAllocationContext().getResourceContainer_AllocationContext(), (ResourceType)activeJob.getProcessingResourceType());
            Optional<ActiveResource> activeResource = this.resourceTable.getActiveResource(id);
            if (activeResource.isEmpty()) {
                LOGGER.warn((Object)("No such resource found! Job cannot be initiated, instead abort. Resource Id:" + id.toString()));
                return Result.of((Object[])new AbstractJobEvent[]{new JobAborted((Job)activeJob, 0.0, "active resource is not found, may have been deleted")});
            }
            return Result.of(activeResource.get().onJobInitiated(jobInitiated));
        }
        if (job instanceof LinkingJob) {
            LinkingJob linkingJob = (LinkingJob)job;
            Optional linkingResource = this.linkingResourceTable.getResourceById(linkingJob.getLinkingResource().getId());
            if (linkingResource.isEmpty()) {
                LOGGER.warn((Object)"No such resource found! Job cannot be initiated, instead abort.");
                return Result.of((Object[])new AbstractJobEvent[]{new JobAborted((Job)linkingJob, 0.0, "linking resource is not found")});
            }
            LOGGER.info((Object)("A linking job has started with id " + linkingJob.getId() + " and demand (without latency) " + linkingJob.getDemand()));
            Set<AbstractJobEvent> jobs = ((SimulatedLinkingResource)linkingResource.get()).onJobInitiated(jobInitiated);
            LOGGER.debug((Object)("Size: " + jobs.size()));
            jobs.forEach(j -> LOGGER.debug((Object)("Job is of type: " + j.getClass().getName() + " and id " + j.getId())));
            return Result.of(jobs);
        }
        return Result.empty();
    }

    @Subscribe
    public Result<AbstractResourceRequestEvent> onPassiveResourceReleased(PassiveResourceReleased passiveResourceReleased) {
        ResourceDemandRequest entity = (ResourceDemandRequest)passiveResourceReleased.getEntity();
        Optional<SimplePassiveResource> passiveResource = this.passiveResourceTable.getPassiveResource(PassiveResourceCompoundKey.of((PassiveResource)entity.getPassiveResource().get(), entity.getAssemblyContext()));
        if (passiveResource.isEmpty()) {
            LOGGER.error((Object)"No such passive resource found!");
            return Result.of((Object[])new AbstractResourceRequestEvent[0]);
        }
        WaitingJob waitingJob = this.createWaitingJob(entity, (PassiveResource)entity.getPassiveResource().get());
        HashSet<Object> newEvents = new HashSet<Object>();
        newEvents.addAll(passiveResource.get().release(waitingJob));
        newEvents.add(new PassiveResourceStateUpdated(entity, passiveResource.get().getCurrentlyAvailable()));
        return Result.of(newEvents);
    }

    @Subscribe
    public Result<AbstractJobEvent> onJobProgressed(JobProgressed jobProgressed) {
        Job job = (Job)jobProgressed.getEntity();
        if (job instanceof ActiveJob) {
            ActiveJob activeJob = (ActiveJob)job;
            ActiveResourceCompoundKey id = ActiveResourceCompoundKey.of(activeJob.getAllocationContext().getResourceContainer_AllocationContext(), (ResourceType)activeJob.getProcessingResourceType());
            Optional<ActiveResource> activeResource = this.resourceTable.getActiveResource(id);
            if (activeResource.isEmpty()) {
                LOGGER.warn((Object)"No such resource found!, Job cannot progress, instead must be aborted.");
                return Result.of((Object[])new AbstractJobEvent[]{new JobAborted((Job)activeJob, 0.0, "active resource is not found, may have been deleted")});
            }
            return Result.of(activeResource.get().onJobProgressed(jobProgressed));
        }
        if (job instanceof LinkingJob) {
            LinkingJob linkingJob = (LinkingJob)job;
            Optional linkingResource = this.linkingResourceTable.getResourceById(linkingJob.getLinkingResource().getId());
            if (linkingResource.isEmpty()) {
                LOGGER.warn((Object)"No such resource found!, Job cannot progress, instead must be aborted!");
                return Result.of((Object[])new AbstractJobEvent[]{new JobAborted((Job)linkingJob, 0.0, "linking resource is not found")});
            }
            LOGGER.info((Object)("A linking job has been progressed: " + linkingJob.getId() + " with demand " + linkingJob.getDemand()));
            return Result.of(((SimulatedLinkingResource)linkingResource.get()).onJobProgressed(jobProgressed));
        }
        return Result.empty();
    }

    @Subscribe
    public Result<?> onJobFinished(JobFinished evt) {
        if (evt.getEntity() instanceof ActiveJob) {
            ActiveJob activeJob = (ActiveJob)evt.getEntity();
            return Result.of((Object[])new ActiveResourceFinished[]{new ActiveResourceFinished(activeJob.getRequest(), 0.0)});
        }
        if (evt.getEntity() instanceof LinkingJob) {
            LinkingJob linkingJob = (LinkingJob)evt.getEntity();
            LOGGER.info((Object)("The linking job with id " + linkingJob.getId() + " has finished"));
            return Result.of((Object[])new CallOverWireSucceeded[]{new CallOverWireSucceeded(linkingJob.getRequest())});
        }
        return Result.empty();
    }

    @Subscribe
    public Result<?> onJobAborted(JobAborted aborted) {
        if (aborted.getEntity() instanceof ActiveJob) {
            ActiveJob activeJob = (ActiveJob)aborted.getEntity();
            return Result.of((Object[])new ResourceDemandRequestAborted[]{new ResourceDemandRequestAborted(activeJob.getRequest())});
        }
        if (aborted.getEntity() instanceof LinkingJob) {
            LinkingJob linkingJob = (LinkingJob)aborted.getEntity();
            return Result.of((Object[])new CallOverWireAborted[]{new CallOverWireAborted(linkingJob.getRequest())});
        }
        return Result.empty();
    }

    @Subscribe
    public Result<?> onModelAdjusted(ModelAdjusted modelChanged) {
        modelChanged.getChanges().stream().filter(change -> change instanceof ResourceEnvironmentChange).map(ResourceEnvironmentChange.class::cast).forEach(this::changeActiveResourceTableFromModelChange);
        modelChanged.getChanges().stream().filter(change -> change instanceof AllocationChange).map(AllocationChange.class::cast).forEach(this::changePassiveResources);
        return Result.empty();
    }

    private void changePassiveResources(AllocationChange allocationchange1) {
        this.passiveResourceTable.buildPassiveResources(allocationchange1.getNewAllocationContexts());
    }

    private void changeActiveResourceTableFromModelChange(ResourceEnvironmentChange change) {
        change.getNewResourceContainers().forEach(newContainer -> this.resourceTable.createActiveResourcesFromResourceContainer((ResourceContainer)newContainer));
        change.getDeletedResourceContainers().forEach(deletedContainer -> this.resourceTable.removeActiveResources((ResourceContainer)deletedContainer));
    }

    @Subscribe
    public Result<?> onCallOverWireRequested(CallOverWireRequested externalCallRequested) {
        Optional<AllocationContext> fromAlC = this.resourceEnvironmentAccessor.findResourceContainerOfComponent(externalCallRequested.getRequest().getFrom());
        Optional<AllocationContext> toAlC = this.resourceEnvironmentAccessor.findResourceContainerOfComponent(externalCallRequested.getRequest().getTo());
        if (fromAlC.isPresent() && toAlC.isPresent()) {
            if (fromAlC.get().getResourceContainer_AllocationContext().getId().equals(toAlC.get().getResourceContainer_AllocationContext().getId())) {
                LOGGER.info((Object)"Both components lie on the same resource container -> no call over wire required.");
                return Result.of((Object[])new CallOverWireSucceeded[]{new CallOverWireSucceeded(externalCallRequested.getRequest())});
            }
            List<SimulatedLinkingResource> linkingResources = this.linkingResourceTable.findLinkingResourceBetweenContainers(fromAlC.get().getResourceContainer_AllocationContext(), toAlC.get().getResourceContainer_AllocationContext());
            if (linkingResources.isEmpty()) {
                linkingResources = this.linkingResourceTable.findLinkingResourceWithAtLeastOneContainer(fromAlC.get().getResourceContainer_AllocationContext(), toAlC.get().getResourceContainer_AllocationContext());
            }
            return Result.of((Object[])new JobInitiated[]{linkingResources.stream().findAny().map(lr -> this.createLinkingJobFromResource(lr.getLinkingResource(), externalCallRequested.getRequest())).map(job -> new JobInitiated((Job)job, 0.0)).orElseThrow(() -> new IllegalArgumentException("The resource containers of the assembly contexts are not directly connected by a linking resource"))});
        }
        return Result.of((Object[])new CallOverWireSucceeded[]{new CallOverWireSucceeded(externalCallRequested.getRequest())});
    }

    private LinkingJob createLinkingJobFromResource(LinkingResource linkingResource, CallOverWireRequest request) {
        double demand = request.getVariablesToConsider().getContents().stream().filter(entry -> ((String)entry.getKey()).endsWith("BYTESIZE")).mapToDouble(entry -> NumberConverter.toDouble(entry.getValue())).sum();
        return new LinkingJob(UUID.randomUUID().toString(), demand, linkingResource, request);
    }

    @Subscribe
    public void onSimulationFinished(SimulationFinished simulationFinished) {
        this.resourceTable.clearResourcesFromJobs();
        this.passiveResourceTable.clearResourcesFromJobs();
        this.linkingResourceTable.clearResourcesFromJobs();
    }
}

