/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.repository;

import java.util.Optional;
import javax.inject.Inject;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.pcm.resourcetype.ResourceType;

public class ResourceEnvironmentAccessor {
    private final ResourceEnvironment resourceEnvironment;
    private final Allocation allocation;

    @Inject
    public ResourceEnvironmentAccessor(Allocation allocation) {
        this.allocation = allocation;
        this.resourceEnvironment = allocation.getTargetResourceEnvironment_Allocation();
    }

    public Optional<ProcessingResourceSpecification> findResourceSpecification(ResourceContainer container, ResourceType type) {
        assert (this.resourceEnvironment.getResourceContainer_ResourceEnvironment().contains((Object)container));
        return container.getActiveResourceSpecifications_ResourceContainer().stream().filter(spec -> type.getId().equals(spec.getActiveResourceType_ActiveResourceSpecification().getId())).findFirst();
    }

    public Optional<AllocationContext> findResourceContainerOfComponent(AssemblyContext assemblyContext) {
        return this.allocation.getAllocationContexts_Allocation().stream().filter(allocationContext -> allocationContext.getAssemblyContext_AllocationContext().getId().equals(assemblyContext.getId())).findFirst();
    }

    public static ResourceEnvironmentAccessor with(Allocation allocation) {
        return new ResourceEnvironmentAccessor(allocation);
    }
}

