/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources;

import com.google.common.base.Preconditions;
import java.util.Objects;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.IResource;

public abstract class AbstractResource
implements IResource {
    private final long capacity;
    private final String name;
    private final Object id;

    public AbstractResource(long capacity, String name, Object id) {
        this.capacity = capacity;
        this.name = name;
        this.id = Preconditions.checkNotNull((Object)id, (Object)"The id must not be null for a resource.");
    }

    public long getCapacity() {
        return this.capacity;
    }

    public String getName() {
        return this.name;
    }

    public Object getId() {
        return this.id;
    }

    public int hashCode() {
        return Objects.hash(this.id);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof AbstractResource)) {
            return false;
        }
        AbstractResource other = (AbstractResource)obj;
        return Objects.equals(this.id, other.id);
    }

    public String toString() {
        return "Resource [name=" + this.name + ", id=" + this.id + "]";
    }
}

