/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active;

import de.uka.ipd.sdq.probfunction.math.util.MathTools;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.Job;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.ProcessingRate;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.AbstractJobEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ActiveResourceStateUpdated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobFinished;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobInitiated;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.JobProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.events.ProcessorSharingJobProgressed;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.AbstractActiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.active.ActiveResourceCompoundKey;

public final class ProcessorSharingResource
extends AbstractActiveResource {
    private static final double JIFFY = 1.0E-9;
    private final Hashtable<Job, Double> runningJobs = new Hashtable();
    private final List<Integer> numberProcessesOnCore;
    private double internalTime;
    private UUID currentState;

    public ProcessorSharingResource(ActiveResourceCompoundKey type, String name, long capacity, ProcessingRate rate) {
        super(type, name, capacity, rate);
        this.numberProcessesOnCore = new ArrayList<Integer>((int)capacity);
        int i = 0;
        while ((long)i < capacity) {
            this.numberProcessesOnCore.add(0);
            ++i;
        }
    }

    @Override
    protected Optional<AbstractJobEvent> process(JobInitiated jobInitiated) {
        this.updateInternalTimer(jobInitiated.time());
        Job newJob = (Job)jobInitiated.getEntity();
        if (newJob.getDemand() < 1.0E-9) {
            newJob.updateDemand(1.0E-9);
        }
        this.runningJobs.put(newJob, newJob.getDemand());
        this.reportCoreUsage();
        return this.scheduleNextEvent().map(j -> j);
    }

    @Override
    public Set<AbstractJobEvent> process(JobProgressed jobProgressed) {
        if (!(jobProgressed instanceof ProcessorSharingJobProgressed)) {
            return Set.of();
        }
        ProcessorSharingJobProgressed processorSharingJobProgressed = (ProcessorSharingJobProgressed)jobProgressed;
        if (processorSharingJobProgressed.getExpectedState().compareTo(this.currentState) != 0) {
            return Set.of();
        }
        this.updateInternalTimer(jobProgressed.time());
        Job shortestJob = (Job)processorSharingJobProgressed.getEntity();
        this.runningJobs.remove(shortestJob);
        this.reportCoreUsage();
        Optional<ProcessorSharingJobProgressed> next = this.scheduleNextEvent();
        if (next.isPresent()) {
            return Set.of(new JobFinished(shortestJob), (AbstractJobEvent)next.get());
        }
        return Set.of(new JobFinished(shortestJob));
    }

    @Override
    public void abortJob(Job job) {
        this.runningJobs.remove(job);
        this.reportCoreUsage();
    }

    public void clearJobs() {
        this.runningJobs.clear();
        int i = 0;
        while ((long)i < this.getCapacity()) {
            this.numberProcessesOnCore.set(i, 0);
            ++i;
        }
    }

    private Optional<ProcessorSharingJobProgressed> scheduleNextEvent() {
        if (this.runningJobs.isEmpty()) {
            return Optional.empty();
        }
        this.currentState = UUID.randomUUID();
        Job shortestJob = null;
        for (Job job : this.runningJobs.keySet()) {
            if (shortestJob != null && !(this.runningJobs.get(shortestJob) > this.runningJobs.get(job))) continue;
            shortestJob = job;
        }
        double remainingTime = this.runningJobs.get(shortestJob) * this.getProcessingDelayFactorPerProcess();
        remainingTime = remainingTime < 1.0E-9 ? 0.0 : remainingTime;
        return Optional.of(new ProcessorSharingJobProgressed(shortestJob, remainingTime, this.currentState));
    }

    private void updateInternalTimer(double simulationTime) {
        double passedTime = simulationTime - this.internalTime;
        double processedDemandPerThread = passedTime / this.getProcessingDelayFactorPerProcess();
        if (MathTools.less((double)0.0, (double)passedTime)) {
            for (Map.Entry<Job, Double> e : this.runningJobs.entrySet()) {
                double rem = e.getValue() - processedDemandPerThread;
                e.setValue(rem);
                e.getKey().updateDemand(rem);
            }
        }
        this.internalTime = simulationTime;
    }

    private double getProcessingDelayFactorPerProcess() {
        double speed = (double)this.runningJobs.size() / (double)this.getCapacity();
        return speed < 1.0 ? 1.0 : speed;
    }

    private void reportCoreUsage() {
        if ((long)this.runningJobs.size() < this.getCapacity()) {
            int i = 0;
            while ((long)i < this.getCapacity()) {
                if (i < this.runningJobs.size()) {
                    this.assignProcesses(1, i);
                } else {
                    this.assignProcesses(0, i);
                }
                ++i;
            }
        } else {
            int minNumberProcessesAtCore = (int)Math.floor((long)this.runningJobs.size() / this.getCapacity());
            int numberAdditionalProcesses = (int)((long)this.runningJobs.size() - (long)minNumberProcessesAtCore * this.getCapacity());
            int i = 0;
            while ((long)i < this.getCapacity()) {
                int numberProcessesAtCore;
                if (numberAdditionalProcesses > 0) {
                    numberProcessesAtCore = minNumberProcessesAtCore + 1;
                    --numberAdditionalProcesses;
                } else {
                    numberProcessesAtCore = minNumberProcessesAtCore;
                }
                this.assignProcesses(numberProcessesAtCore, i);
                ++i;
            }
        }
    }

    private void assignProcesses(int targetNumberProcessesAtCore, int coreNumber) {
        if (this.numberProcessesOnCore.get(coreNumber) != targetNumberProcessesAtCore) {
            this.numberProcessesOnCore.set(coreNumber, targetNumberProcessesAtCore);
        }
    }

    @Override
    protected ActiveResourceStateUpdated publishState(Job job) {
        int waitingJobs = this.runningJobs.size();
        double numberOfActiveCores = this.numberProcessesOnCore.stream().filter(core -> core > 0).collect(Collectors.toList()).size();
        double utilization = numberOfActiveCores / (double)this.numberProcessesOnCore.size();
        return new ActiveResourceStateUpdated(job, (long)waitingJobs, utilization);
    }
}

