/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive;

import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.jobs.WaitingJob;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.entities.resources.IPassiveResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.AbstractResource;
import org.palladiosimulator.analyzer.slingshot.behavior.resourcesimulation.resources.passive.PassiveResourceCompoundKey;
import org.palladiosimulator.analyzer.slingshot.behavior.systemsimulation.events.PassiveResourceAcquired;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.PassiveResource;

public final class SimplePassiveResource
extends AbstractResource
implements IPassiveResource {
    private final Queue<WaitingJob> waitingJobs = new ArrayDeque<WaitingJob>();
    private long available;

    public SimplePassiveResource(PassiveResourceCompoundKey id, long capacity) {
        super(capacity, id.getPassiveResource().getEntityName(), id);
        this.available = capacity;
    }

    public void clearJobs() {
        this.waitingJobs.clear();
    }

    public Optional<PassiveResourceAcquired> acquire(WaitingJob waitingJob) {
        if (this.acquirable(waitingJob)) {
            return Optional.of(this.grantAccess(waitingJob));
        }
        this.waitingJobs.offer(waitingJob);
        return Optional.empty();
    }

    public Set<PassiveResourceAcquired> release(WaitingJob waitingJob) {
        this.available += waitingJob.getDemand();
        HashSet<PassiveResourceAcquired> events = new HashSet<PassiveResourceAcquired>();
        WaitingJob nextJob = this.waitingJobs.peek();
        while (nextJob != null && this.acquirable(nextJob)) {
            events.add(this.grantAccess(nextJob));
            nextJob = this.waitingJobs.peek();
        }
        return events;
    }

    public boolean acquirable(WaitingJob waitingJob) {
        return (this.waitingJobs.isEmpty() || this.waitingJobs.peek().equals(waitingJob)) && waitingJob.getDemand() <= this.available;
    }

    private PassiveResourceAcquired grantAccess(WaitingJob waitingJob) {
        assert (this.acquirable(waitingJob));
        this.available -= waitingJob.getDemand();
        this.waitingJobs.remove(waitingJob);
        return new PassiveResourceAcquired(waitingJob.getRequest());
    }

    public long getCurrentlyAvailable() {
        return this.available;
    }

    public PassiveResource getPCMPassiveResource() {
        return ((PassiveResourceCompoundKey)this.getId()).getPassiveResource();
    }

    public AssemblyContext getAssemblyContext() {
        return ((PassiveResourceCompoundKey)this.getId()).getAssemblyContext();
    }
}

