/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelParameter;
import org.eclipse.m2m.internal.qvt.oml.expressions.ModelType;
import org.eclipse.m2m.internal.qvt.oml.expressions.OperationalTransformation;
import org.eclipse.m2m.internal.qvt.oml.expressions.util.ExpressionsSwitch;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToModelTransformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToPoolingModelTransformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToTransformationExecutor;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.TransformationParameterInformation;

public class ModelTransformationFactory {
    private final ResourceSet resourceSet = new ResourceSetImpl();
    private static final ExpressionsSwitch<EPackage> PARAM_META_MODEL_SWITCH = new ExpressionsSwitch<EPackage>(){

        public EPackage caseModelType(ModelType modelType) {
            return (EPackage)modelType.getMetamodel().get(0);
        }
    };
    private static final ExpressionsSwitch<OperationalTransformation> OPERATIONAL_TRANSFORMATION_SWITCH = new ExpressionsSwitch<OperationalTransformation>(){

        public OperationalTransformation caseOperationalTransformation(OperationalTransformation transformation) {
            return transformation;
        }
    };

    public QVToModelTransformation createModelTransformation(URI transformationUri) {
        Resource transformationResource = this.resourceSet.getResource(Objects.requireNonNull(transformationUri), true);
        OperationalTransformation transformation = null;
        if (!transformationResource.getContents().isEmpty()) {
            transformation = (OperationalTransformation)OPERATIONAL_TRANSFORMATION_SWITCH.doSwitch((EObject)transformationResource.getContents().get(0));
        }
        if (transformation == null) {
            throw new IllegalArgumentException("OperationalTransformation instance could not be retrieved from resource contents.");
        }
        return new QVToPoolingModelTransformation(transformation, () -> new QVToTransformationExecutor(transformationUri), this.createTransformationParameterInformation(transformation));
    }

    private Collection<TransformationParameterInformation> createTransformationParameterInformation(OperationalTransformation transformation) {
        assert (transformation != null);
        EList parameters = transformation.getModelParameter();
        ArrayList<TransformationParameterInformation> result = new ArrayList<TransformationParameterInformation>(parameters.size());
        int index = 0;
        for (ModelParameter parameter : parameters) {
            result.add(new TransformationParameterInformation((EPackage)PARAM_META_MODEL_SWITCH.doSwitch((EObject)parameter.getType()), parameter.getKind(), index++, parameter.getName()));
        }
        return result;
    }
}

