/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToModelTransformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToReconfigurator;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.ModelAdjustmentRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.monitor.ResourceContainerMonitorCloner;
import org.palladiosimulator.analyzer.slingshot.common.annotations.Nullable;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.AllocationChange;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ModelAdjusted;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.MonitorChange;
import org.palladiosimulator.analyzer.slingshot.common.events.modelchanges.ResourceEnvironmentChange;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcm.resourceenvironment.ResourceEnvironment;
import org.palladiosimulator.semanticspd.Configuration;
import org.palladiosimulator.semanticspd.ElasticInfrastructureCfg;
import org.palladiosimulator.semanticspd.SemanticspdFactory;
import org.palladiosimulator.spd.SPD;

@OnEvent(when=ModelAdjustmentRequested.class, then={ModelAdjusted.class}, cardinality=EventCardinality.SINGLE)
public class SpdAdjustmentBehavior
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(SpdAdjustmentBehavior.class);
    private final boolean activated;
    private final SPD spd;
    private final QVToReconfigurator reconfigurator;
    private final Iterable<QVToModelTransformation> transformations;
    private final Allocation allocation;
    private final Configuration semanticConfiguration;
    private final MonitorRepository monitorRepository;

    @Inject
    public SpdAdjustmentBehavior(Allocation allocation, @Nullable MonitorRepository monitorRepository, @Nullable Configuration semanticConfiguration, @Nullable SPD spd, QVToReconfigurator reconfigurator, @Named(value="mainqvto") @Named(value="mainqvto") Iterable<QVToModelTransformation> transformations) {
        this.activated = monitorRepository != null && semanticConfiguration != null && spd != null;
        this.allocation = allocation;
        this.semanticConfiguration = semanticConfiguration;
        this.spd = spd;
        this.reconfigurator = reconfigurator;
        this.transformations = transformations;
        this.monitorRepository = monitorRepository;
    }

    public boolean isActive() {
        return this.activated;
    }

    @Subscribe
    public Result<ModelAdjusted> onModelAdjustmentRequested(ModelAdjustmentRequested event) {
        ResourceEnvironment environment = this.allocation.getTargetResourceEnvironment_Allocation();
        this.semanticConfiguration.setEnactedPolicy(event.getScalingPolicy());
        ArrayList oldContainers = new ArrayList(environment.getResourceContainer_ResourceEnvironment());
        ArrayList oldAllocationContexts = new ArrayList(this.allocation.getAllocationContexts_Allocation());
        boolean result = this.reconfigurator.execute(this.transformations);
        LOGGER.debug((Object)("RECONFIGURATION WAS " + result));
        if (result) {
            LOGGER.debug((Object)("Number of resource container is now: " + environment.getResourceContainer_ResourceEnvironment().size()));
            ArrayList<ResourceContainer> newResourceContainers = new ArrayList<ResourceContainer>((Collection<ResourceContainer>)environment.getResourceContainer_ResourceEnvironment());
            newResourceContainers.removeAll(oldContainers);
            ArrayList deletedResourceContainers = new ArrayList(oldContainers);
            deletedResourceContainers.removeAll((Collection<?>)environment.getResourceContainer_ResourceEnvironment());
            ArrayList newAllocationContexts = new ArrayList(this.allocation.getAllocationContexts_Allocation());
            newAllocationContexts.removeAll(oldAllocationContexts);
            ArrayList<Object> changes = new ArrayList<Object>();
            changes.add(ResourceEnvironmentChange.builder().resourceEnvironment(environment).simulationTime(event.time()).oldResourceContainers(oldContainers).newResourceContainers(newResourceContainers).deletedResourceContainers(deletedResourceContainers).build());
            changes.add(AllocationChange.builder().allocation(this.allocation).newAllocationContexts(newAllocationContexts).build());
            changes.addAll(this.createMonitors(newResourceContainers, event.time()));
            return Result.of((Object[])new ModelAdjusted[]{new ModelAdjusted(true, changes)});
        }
        return Result.of((Object[])new ModelAdjusted[]{new ModelAdjusted(false, Collections.emptyList())});
    }

    private List<MonitorChange> createMonitors(List<ResourceContainer> newContainers, double simulationTime) {
        if (newContainers.isEmpty() || this.getUnitContainer(newContainers.get(0)) == null) {
            return Collections.emptyList();
        }
        ResourceContainer unitContainer = this.getUnitContainer(newContainers.get(0));
        ResourceContainerMonitorCloner cloner = new ResourceContainerMonitorCloner(this.monitorRepository, ((Monitor)this.monitorRepository.getMonitors().get(0)).getMeasuringPoint().getMeasuringPointRepository(), unitContainer);
        return newContainers.stream().flatMap(container -> cloner.createMonitorsForResourceContainer((ResourceContainer)container).stream()).map(newMonitor -> new MonitorChange(newMonitor, null, simulationTime)).toList();
    }

    private ResourceContainer getUnitContainer(ResourceContainer referenceContainer) {
        assert (referenceContainer != null) : "Reference Container is null but must not be null.";
        return this.semanticConfiguration.getTargetCfgs().stream().filter(ElasticInfrastructureCfg.class::isInstance).map(ElasticInfrastructureCfg.class::cast).filter(eicfg -> eicfg.getElements().contains((Object)referenceContainer)).map(el -> el.getUnit()).findAny().orElse(null);
    }

    private ElasticInfrastructureCfg createElasticInfrastructureCfg(ResourceEnvironment environment) {
        ElasticInfrastructureCfg targetGroupConfig = SemanticspdFactory.eINSTANCE.createElasticInfrastructureCfg();
        targetGroupConfig.setResourceEnvironment(environment);
        targetGroupConfig.setUnit((ResourceContainer)environment.getResourceContainer_ResourceEnvironment().stream().findAny().get());
        targetGroupConfig.getElements().addAll((Collection)environment.getResourceContainer_ResourceEnvironment());
        targetGroupConfig.setUnit(null);
        return targetGroupConfig;
    }

    private Configuration createConfiguration(ModelAdjustmentRequested event, ResourceEnvironment environment) {
        Configuration configuration = SemanticspdFactory.eINSTANCE.createConfiguration();
        configuration.setAllocation(this.allocation);
        configuration.setResourceEnvironment(environment);
        configuration.setSpd(this.spd);
        configuration.setSystem(this.allocation.getSystem_Allocation());
        configuration.setRepository(((AssemblyContext)this.allocation.getSystem_Allocation().getAssemblyContexts__ComposedStructure().get(0)).getEncapsulatedComponent__AssemblyContext().getRepository__RepositoryComponent());
        configuration.setEnactedPolicy(event.getScalingPolicy());
        ElasticInfrastructureCfg targetGroupConfig = this.createElasticInfrastructureCfg(environment);
        configuration.getTargetCfgs().add((Object)targetGroupConfig);
        return configuration;
    }
}

