/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.util;

import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.SoftReference;
import java.util.Collection;
import java.util.LinkedList;
import java.util.function.Supplier;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToTransformationExecutor;

public class QVToTransformationExecutorPool {
    private final Collection<SoftReference<QVToTransformationExecutor>> availableExecutors = new LinkedList<SoftReference<QVToTransformationExecutor>>();
    private final ReferenceQueue<QVToTransformationExecutor> collectedExecutors = new ReferenceQueue();
    protected final Supplier<QVToTransformationExecutor> executorSupplier;

    public QVToTransformationExecutorPool(Supplier<QVToTransformationExecutor> executorSupplier) {
        this.executorSupplier = executorSupplier;
    }

    public QVToTransformationExecutor getExecutor() {
        Reference<QVToTransformationExecutor> ref2 = this.collectedExecutors.poll();
        while (ref2 != null) {
            this.availableExecutors.remove(ref2);
            ref2 = this.collectedExecutors.poll();
        }
        return this.availableExecutors.stream().map(ref -> (QVToTransformationExecutor)ref.get()).filter(ref -> ref != null).filter(exec -> !exec.isInUse()).findFirst().orElseGet(() -> {
            QVToTransformationExecutor exec = this.executorSupplier.get();
            this.availableExecutors.add(new SoftReference<QVToTransformationExecutor>(exec, this.collectedExecutors));
            return exec;
        });
    }
}

