/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.monitor;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.monitor.ResourceContainerMonitorFinder;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPoint;
import org.palladiosimulator.edp2.models.measuringpoint.MeasuringPointRepository;
import org.palladiosimulator.monitorrepository.MeasurementSpecification;
import org.palladiosimulator.monitorrepository.Monitor;
import org.palladiosimulator.monitorrepository.MonitorRepository;
import org.palladiosimulator.monitorrepository.MonitorRepositoryFactory;
import org.palladiosimulator.monitorrepository.ProcessingType;
import org.palladiosimulator.pcm.resourceenvironment.ProcessingResourceSpecification;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.PcmmeasuringpointFactory;
import org.palladiosimulator.pcmmeasuringpoint.ResourceContainerMeasuringPoint;

public class ResourceContainerMonitorCloner {
    private final MeasuringPointRepository mpRepository;
    private final MonitorRepository monitorRepository;
    private final List<Monitor> unitResourceContainerMonitors;
    private final List<Monitor> unitActiveResourceMonitors;

    public ResourceContainerMonitorCloner(MonitorRepository monitorRepository, MeasuringPointRepository mpRepository, ResourceContainer unit) {
        this.mpRepository = mpRepository;
        this.monitorRepository = monitorRepository;
        ResourceContainerMonitorFinder finder = new ResourceContainerMonitorFinder(monitorRepository);
        this.unitResourceContainerMonitors = (List)finder.doSwitch((EObject)unit);
        this.unitActiveResourceMonitors = unit.getActiveResourceSpecifications_ResourceContainer().stream().flatMap(ar -> ((List)finder.doSwitch((EObject)ar)).stream()).toList();
    }

    public List<Monitor> createMonitorsForResourceContainer(ResourceContainer copiedResourceContainer) {
        ArrayList<Monitor> monitors = new ArrayList<Monitor>(this.unitResourceContainerMonitors.size() + this.unitActiveResourceMonitors.size());
        this.unitResourceContainerMonitors.stream().map(unitMonitor -> this.createMonitor(copiedResourceContainer, (Monitor)unitMonitor)).forEach(monitors::add);
        this.unitActiveResourceMonitors.stream().mapMulti((monitor, acceptor) -> {
            ActiveResourceMeasuringPoint ap = (ActiveResourceMeasuringPoint)monitor.getMeasuringPoint();
            copiedResourceContainer.getActiveResourceSpecifications_ResourceContainer().stream().filter(spec -> ResourceContainerMonitorCloner.isSameProcessingType(spec, ap.getActiveResource())).findAny().ifPresent(spec -> acceptor.accept(this.createMonitor((ProcessingResourceSpecification)spec, (Monitor)monitor)));
        }).forEach(monitors::add);
        return monitors;
    }

    private static boolean isSameProcessingType(ProcessingResourceSpecification firstSpec, ProcessingResourceSpecification secondSpec) {
        return firstSpec.getActiveResourceType_ActiveResourceSpecification().getId().equals(secondSpec.getActiveResourceType_ActiveResourceSpecification().getId());
    }

    private Monitor createMonitor(ResourceContainer resourceContainer, Monitor originalMonitor) {
        Monitor monitor = this.createMonitor(originalMonitor);
        monitor.setMeasuringPoint(this.createMeasuringPoint(resourceContainer, originalMonitor.getMeasuringPoint()));
        return monitor;
    }

    private MeasuringPoint createMeasuringPoint(ResourceContainer resourceContainer, MeasuringPoint originalMeasuringPoint) {
        if (originalMeasuringPoint instanceof ResourceContainerMeasuringPoint) {
            ResourceContainerMeasuringPoint copy = PcmmeasuringpointFactory.eINSTANCE.createResourceContainerMeasuringPoint();
            copy.setMeasuringPointRepository(this.mpRepository);
            copy.setResourceContainer(resourceContainer);
            this.mpRepository.getMeasuringPoints().add((Object)copy);
            return copy;
        }
        return null;
    }

    private Monitor createMonitor(Monitor originalMonitor) {
        Monitor monitor = MonitorRepositoryFactory.eINSTANCE.createMonitor();
        monitor.setActivated(originalMonitor.isActivated());
        monitor.setEntityName(String.valueOf(originalMonitor.getEntityName()) + "-copy");
        monitor.setId(EcoreUtil.generateUUID());
        originalMonitor.getMeasurementSpecifications().stream().map(spec -> this.createMeasurementSpec((MeasurementSpecification)spec, monitor)).forEach(arg_0 -> monitor.getMeasurementSpecifications().add(arg_0));
        monitor.setMonitorRepository(this.monitorRepository);
        this.monitorRepository.getMonitors().add((Object)monitor);
        return monitor;
    }

    private MeasurementSpecification createMeasurementSpec(MeasurementSpecification originalSpec, Monitor newMonitor) {
        MeasurementSpecification newSpecification = MonitorRepositoryFactory.eINSTANCE.createMeasurementSpecification();
        newSpecification.setMetricDescription(originalSpec.getMetricDescription());
        newSpecification.setId(EcoreUtil.generateUUID());
        newSpecification.setMonitor(newMonitor);
        newSpecification.setProcessingType(this.createProcessingType(originalSpec.getProcessingType(), newSpecification));
        newSpecification.setTriggersSelfAdaptations(originalSpec.isTriggersSelfAdaptations());
        return newSpecification;
    }

    private ProcessingType createProcessingType(ProcessingType original, MeasurementSpecification newSpecification) {
        EcoreUtil.Copier copier = new EcoreUtil.Copier();
        ProcessingType pt = (ProcessingType)copier.copy((EObject)original);
        copier.copyReferences();
        pt.setMeasurementSpecification(newSpecification);
        pt.setId(EcoreUtil.generateUUID());
        return pt;
    }

    private Monitor createMonitor(ProcessingResourceSpecification spec, Monitor originalMonitor) {
        Monitor monitor = this.createMonitor(originalMonitor);
        monitor.setMeasuringPoint(this.createMeasuringPoint(spec, originalMonitor.getMeasuringPoint()));
        return monitor;
    }

    private MeasuringPoint createMeasuringPoint(ProcessingResourceSpecification spec, MeasuringPoint originalMeasuringPoint) {
        if (originalMeasuringPoint instanceof ActiveResourceMeasuringPoint var3_4) {
            ActiveResourceMeasuringPoint copy = PcmmeasuringpointFactory.eINSTANCE.createActiveResourceMeasuringPoint();
            copy.setMeasuringPointRepository(this.mpRepository);
            copy.setActiveResource(spec);
            copy.setReplicaID(acMP.getReplicaID());
            this.mpRepository.getMeasuringPoints().add((Object)copy);
            return copy;
        }
        return null;
    }
}

