/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.m2m.qvt.oml.BasicModelExtent;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionContextImpl;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.util.Log;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToModelTransformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.QVToReconfigurationLogger;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.TransformationParameterInformation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.util.ModelTransformationCache;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto.util.QVToModelCache;

public abstract class AbstractQVToExecutor {
    private static final Logger LOGGER = Logger.getLogger(AbstractQVToExecutor.class);
    private final QVToModelCache availableModels;
    private final ModelTransformationCache transformationCache;
    private static final Function<EObject, Collection<EObject>> CREATE_NON_EMPTY_MODEL_ELEMENTS_SWITCH = e -> Collections.singletonList(e);
    private static final Collector<EObject, List<EObject>, ModelExtent> BASIC_MODEL_EXTENT_COLLECTOR = Collector.of(ArrayList::new, (acc, t) -> {
        boolean bl = acc.add(t);
    }, (l, r) -> {
        l.addAll(r);
        return l;
    }, BasicModelExtent::new, new Collector.Characteristics[0]);

    protected AbstractQVToExecutor(ModelTransformationCache knownTransformations, QVToModelCache knownModels) {
        this.transformationCache = Objects.requireNonNull(knownTransformations);
        this.availableModels = Objects.requireNonNull(knownModels);
    }

    protected ModelTransformationCache getAvailableTransformations() {
        return this.transformationCache;
    }

    protected QVToModelCache getAvailableModels() {
        return this.availableModels;
    }

    public boolean executeTransformation(URI transformationURI) {
        Optional<QVToModelTransformation> data = this.transformationCache.get(Objects.requireNonNull(transformationURI));
        return this.executeTransformation(data.orElseThrow(() -> new IllegalArgumentException("Given transformation not present in transformation cache.")));
    }

    public final boolean executeTransformation(QVToModelTransformation modelTransformation) {
        ExecutionDiagnostic result = this.executeTransformationInternal(modelTransformation);
        return this.handleExecutionResult(result);
    }

    protected ExecutionDiagnostic executeTransformationInternal(QVToModelTransformation modelTransformation) {
        ModelExtent[] modelExtents = this.setupModelExtents(Objects.requireNonNull(modelTransformation));
        ExecutionContext executionContext = this.setupExecutionContext();
        ExecutionDiagnostic result = this.doExecution(modelTransformation, executionContext, modelExtents);
        return result;
    }

    protected final ExecutionDiagnostic doExecution(QVToModelTransformation modelTransformation, ExecutionContext executionContext, ModelExtent[] params) {
        return modelTransformation.getTransformationExecutor().execute(executionContext, params);
    }

    protected boolean handleExecutionResult(ExecutionDiagnostic executionResult) {
        int severity = executionResult.getSeverity();
        if (severity == 0 || severity == 1) {
            LOGGER.debug((Object)("Succcesful rule application: " + executionResult.getMessage()));
            return true;
        }
        List details = executionResult.getChildren();
        String chainedDetails = details.stream().map(Object::toString).collect(Collectors.joining(","));
        Level level = severity >= 4 ? Level.ERROR : Level.WARN;
        LOGGER.log((Priority)level, (Object)String.format("%s; %s", executionResult.getMessage(), chainedDetails), executionResult.getException());
        return false;
    }

    protected ExecutionContext setupExecutionContext() {
        ExecutionContextImpl result = new ExecutionContextImpl();
        result.setLog(this.createLog());
        result.setConfigProperty("keepModeling", (Object)true);
        return result;
    }

    protected Log createLog() {
        return new QVToReconfigurationLogger(this.getClass());
    }

    protected ModelExtent[] setupModelExtents(QVToModelTransformation transformation) {
        assert (transformation != null && transformation.getTransformationExecutor() != null);
        ModelExtent[] modelExtents = new ModelExtent[transformation.getParameterCount()];
        for (TransformationParameterInformation inParams : transformation.getInParameters()) {
            Collection<EObject> sourceModel = this.availableModels.getModelsByType(inParams.getParameterType());
            if (sourceModel.isEmpty()) {
                throw new IllegalStateException("No model in QVTo model cache for " + (inParams.getParameterIndex() + 1) + " of parameter type " + inParams.getParameterType().getName() + " Parameter of transformation '" + transformation.getTransformationName() + "'");
            }
            modelExtents[inParams.getParameterIndex()] = sourceModel.stream().map(CREATE_NON_EMPTY_MODEL_ELEMENTS_SWITCH::apply).flatMap(Collection::stream).collect(BASIC_MODEL_EXTENT_COLLECTOR);
        }
        transformation.getPureOutParameters().stream().mapToInt(TransformationParameterInformation::getParameterIndex).forEach(index -> {
            BasicModelExtent basicModelExtent = new BasicModelExtent();
        });
        return modelExtents;
    }
}

