/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.adjustment.qvto;

import java.util.Optional;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.m2m.qvt.oml.ExecutionContext;
import org.eclipse.m2m.qvt.oml.ExecutionDiagnostic;
import org.eclipse.m2m.qvt.oml.ModelExtent;
import org.eclipse.m2m.qvt.oml.TransformationExecutor;

public class QVToTransformationExecutor {
    private final AtomicBoolean inUse = new AtomicBoolean(false);
    protected TransformationExecutor internalExecutor = null;

    public QVToTransformationExecutor(URI uri) {
        this.setupInternalExecutor(uri, null);
    }

    public QVToTransformationExecutor(URI uri, EPackage.Registry registry) {
        this.setupInternalExecutor(uri, registry);
    }

    public Diagnostic loadTransformation() {
        return this.internalExecutor.loadTransformation();
    }

    public Diagnostic loadTransformation(IProgressMonitor progressMonitor) {
        return this.internalExecutor.loadTransformation(progressMonitor);
    }

    public ExecutionDiagnostic execute(ExecutionContext executionContext, ModelExtent ... modelParameters) {
        if (!this.inUse.compareAndSet(false, true)) {
            throw new IllegalStateException("This QVToTransformationExecutor instance is already in use.");
        }
        ExecutionDiagnostic result = this.internalExecutor.execute(executionContext, modelParameters);
        this.internalExecutor.cleanup();
        this.inUse.set(false);
        return result;
    }

    public boolean isInUse() {
        return this.inUse.get();
    }

    protected void setupInternalExecutor(URI uri, EPackage.Registry registry) {
        this.internalExecutor = Optional.ofNullable(registry).map(r -> new TransformationExecutor(uri, r)).orElseGet(() -> new TransformationExecutor(uri));
    }
}

