/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SpdBasedEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.StimuliInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.Filter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.LogicalANDComboundFilter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.LogicalORCompoundFilter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.LogicalXORCompoundFilter;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.triggers.ComposedTrigger;
import org.palladiosimulator.spd.triggers.LogicalOperator;
import org.palladiosimulator.spd.triggers.SimpleFireOnTrend;
import org.palladiosimulator.spd.triggers.SimpleFireOnValue;
import org.palladiosimulator.spd.triggers.util.TriggersSwitch;

public class ScalingTriggerInterpreter
extends TriggersSwitch<InterpretationResult> {
    final ScalingPolicy policy;

    public ScalingTriggerInterpreter(ScalingPolicy policy) {
        this.policy = policy;
    }

    public InterpretationResult caseComposedTrigger(ComposedTrigger object) {
        return object.getScalingtrigger().stream().map(arg_0 -> ((ScalingTriggerInterpreter)this).doSwitch(arg_0)).reduce((res1, res2) -> res1.addFrom((InterpretationResult)res2, object.getLogicalOperator())).orElseGet(InterpretationResult::new);
    }

    public InterpretationResult caseSimpleFireOnValue(SimpleFireOnValue object) {
        StimuliInterpreter stimuliInterpreter = new StimuliInterpreter(this, object);
        return (InterpretationResult)stimuliInterpreter.doSwitch((EObject)object.getStimulus());
    }

    public InterpretationResult caseSimpleFireOnTrend(SimpleFireOnTrend object) {
        return (InterpretationResult)super.caseSimpleFireOnTrend(object);
    }

    static final class InterpretationResult {
        private Filter triggerChecker;
        private final List<SpdBasedEvent> eventsToSchedule = new ArrayList<SpdBasedEvent>();
        private final List<Subscriber.Builder<? extends DESEvent>> eventsToListen = new ArrayList<Subscriber.Builder<? extends DESEvent>>();

        InterpretationResult() {
        }

        public InterpretationResult triggerChecker(Filter triggerChecker) {
            this.triggerChecker = triggerChecker;
            return this;
        }

        public InterpretationResult scheduleEvent(SpdBasedEvent event) {
            this.eventsToSchedule.add(event);
            return this;
        }

        public InterpretationResult listenEvent(Subscriber.Builder<? extends DESEvent> event) {
            this.eventsToListen.add(event);
            return this;
        }

        public Filter getTriggerChecker() {
            return this.triggerChecker;
        }

        public List<SpdBasedEvent> getEventsToSchedule() {
            return this.eventsToSchedule;
        }

        public List<Subscriber.Builder<? extends DESEvent>> getEventsToListen() {
            return this.eventsToListen;
        }

        /*
         * WARNING - void declaration
         */
        public InterpretationResult addFrom(InterpretationResult other, LogicalOperator operator) {
            this.eventsToSchedule.addAll(other.eventsToSchedule);
            this.eventsToListen.addAll(other.eventsToListen);
            if (this.triggerChecker == null) {
                this.triggerChecker = other.triggerChecker;
            } else {
                switch (operator) {
                    case AND: {
                        Filter temp;
                        Filter filter = temp = this.triggerChecker;
                        if (filter instanceof LogicalANDComboundFilter var4_7) {
                            void chain;
                            chain.add(other.triggerChecker);
                            break;
                        }
                        LogicalANDComboundFilter comboundFilter = new LogicalANDComboundFilter();
                        comboundFilter.add(temp);
                        comboundFilter.add(other.triggerChecker);
                        this.triggerChecker = comboundFilter;
                        break;
                    }
                    case OR: {
                        LogicalORCompoundFilter comboundFilter = new LogicalORCompoundFilter();
                        comboundFilter.add(this.triggerChecker);
                        comboundFilter.add(other.triggerChecker);
                        this.triggerChecker = comboundFilter;
                        break;
                    }
                    case XOR: {
                        LogicalXORCompoundFilter comboundFilter = new LogicalXORCompoundFilter();
                        comboundFilter.add(this.triggerChecker);
                        comboundFilter.add(other.triggerChecker);
                        this.triggerChecker = comboundFilter;
                        break;
                    }
                }
            }
            return this;
        }
    }
}

