/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.utils;

import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.utils.TargetGroupUtils;
import org.palladiosimulator.pcmmeasuringpoint.ActiveResourceMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.AssemblyReference;
import org.palladiosimulator.pcmmeasuringpoint.OperationReference;
import org.palladiosimulator.pcmmeasuringpoint.ResourceContainerMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.ResourceEnvironmentMeasuringPoint;
import org.palladiosimulator.pcmmeasuringpoint.util.PcmmeasuringpointSwitch;
import org.palladiosimulator.spd.targets.TargetGroup;

public class MeasuringPointInsideTargetGroup
extends PcmmeasuringpointSwitch<Boolean> {
    private final TargetGroup targetGroup;

    public MeasuringPointInsideTargetGroup(TargetGroup targetGroup) {
        this.targetGroup = targetGroup;
    }

    public Boolean caseActiveResourceMeasuringPoint(ActiveResourceMeasuringPoint object) {
        return TargetGroupUtils.isContainerInTargetGroup(object.getActiveResource().getResourceContainer_ProcessingResourceSpecification(), this.targetGroup);
    }

    public Boolean caseResourceContainerMeasuringPoint(ResourceContainerMeasuringPoint object) {
        return TargetGroupUtils.isContainerInTargetGroup(object.getResourceContainer(), this.targetGroup);
    }

    public Boolean caseResourceEnvironmentMeasuringPoint(ResourceEnvironmentMeasuringPoint object) {
        return object.getResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().anyMatch(rc -> TargetGroupUtils.isContainerInTargetGroup(rc, this.targetGroup));
    }

    public Boolean caseAssemblyReference(AssemblyReference object) {
        return TargetGroupUtils.isAssemblyInTargetGroup(object.getAssembly(), this.targetGroup);
    }

    public Boolean caseOperationReference(OperationReference object) {
        return TargetGroupUtils.isOperationSinatureRelatedToTargetGroup(object.getOperationSignature(), this.targetGroup);
    }

    public Boolean defaultCase(EObject object) {
        return false;
    }
}

