/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter;

import com.google.common.base.Preconditions;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SimulationTimeReached;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SpdBasedEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.ScalingTriggerInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.CPUUtilizationTriggerChecker;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.OperationResponseTimeTriggerChecker;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.QueueLengthTriggerChecker;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.SimulationTimeChecker;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.TaskCountTriggerChecker;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.MeasurementMade;
import org.palladiosimulator.spd.targets.CompetingConsumersGroup;
import org.palladiosimulator.spd.triggers.SimpleFireOnValue;
import org.palladiosimulator.spd.triggers.expectations.ExpectedCount;
import org.palladiosimulator.spd.triggers.expectations.ExpectedPercentage;
import org.palladiosimulator.spd.triggers.expectations.ExpectedTime;
import org.palladiosimulator.spd.triggers.expectations.ExpectedValue;
import org.palladiosimulator.spd.triggers.stimuli.CPUUtilization;
import org.palladiosimulator.spd.triggers.stimuli.OperationResponseTime;
import org.palladiosimulator.spd.triggers.stimuli.QueueLength;
import org.palladiosimulator.spd.triggers.stimuli.SimulationTime;
import org.palladiosimulator.spd.triggers.stimuli.TaskCount;
import org.palladiosimulator.spd.triggers.stimuli.util.StimuliSwitch;

final class StimuliInterpreter
extends StimuliSwitch<ScalingTriggerInterpreter.InterpretationResult> {
    private final ScalingTriggerInterpreter scalingTriggerInterpreter;
    private final SimpleFireOnValue trigger;

    public StimuliInterpreter(ScalingTriggerInterpreter scalingTriggerInterpreter, SimpleFireOnValue trigger) {
        this.scalingTriggerInterpreter = scalingTriggerInterpreter;
        this.trigger = trigger;
    }

    public ScalingTriggerInterpreter.InterpretationResult caseSimulationTime(SimulationTime object) {
        ExpectedTime expectedTime = this.checkExpectedValue(ExpectedTime.class);
        SimulationTimeReached event = new SimulationTimeReached(this.scalingTriggerInterpreter.policy.getTargetGroup().getId(), expectedTime.getValue());
        return new ScalingTriggerInterpreter.InterpretationResult().scheduleEvent((SpdBasedEvent)event).listenEvent((Subscriber.Builder<? extends DESEvent>)Subscriber.builder(SimulationTimeReached.class).name("something")).triggerChecker(new SimulationTimeChecker(this.trigger));
    }

    public ScalingTriggerInterpreter.InterpretationResult caseOperationResponseTime(OperationResponseTime object) {
        this.checkExpectedValue(ExpectedTime.class);
        return new ScalingTriggerInterpreter.InterpretationResult().listenEvent((Subscriber.Builder<? extends DESEvent>)Subscriber.builder(MeasurementMade.class).name("measurementMade")).triggerChecker(new OperationResponseTimeTriggerChecker(this.trigger));
    }

    public ScalingTriggerInterpreter.InterpretationResult caseCPUUtilization(CPUUtilization object) {
        ExpectedPercentage expectedPercentage = this.checkExpectedValue(ExpectedPercentage.class);
        Preconditions.checkArgument((0.0 <= expectedPercentage.getValue() && expectedPercentage.getValue() <= 100.0 ? 1 : 0) != 0, (Object)"The expected percentage must be between 0 and 100");
        return new ScalingTriggerInterpreter.InterpretationResult().listenEvent((Subscriber.Builder<? extends DESEvent>)Subscriber.builder(MeasurementMade.class).name("cpuUtilizationMade")).triggerChecker(new CPUUtilizationTriggerChecker(this.trigger, object, this.scalingTriggerInterpreter.policy.getTargetGroup()));
    }

    public ScalingTriggerInterpreter.InterpretationResult caseTaskCount(TaskCount object) {
        this.checkExpectedValue(ExpectedCount.class);
        return new ScalingTriggerInterpreter.InterpretationResult().listenEvent((Subscriber.Builder<? extends DESEvent>)Subscriber.builder(MeasurementMade.class).name("taskCount")).triggerChecker(new TaskCountTriggerChecker(this.trigger, object, this.scalingTriggerInterpreter.policy.getTargetGroup()));
    }

    public ScalingTriggerInterpreter.InterpretationResult caseQueueLength(QueueLength object) {
        if (!(this.scalingTriggerInterpreter.policy.getTargetGroup() instanceof CompetingConsumersGroup)) {
            throw new IllegalArgumentException("The QueueLength trigger is only for CompetingConsumersGroup");
        }
        return new ScalingTriggerInterpreter.InterpretationResult().listenEvent((Subscriber.Builder<? extends DESEvent>)Subscriber.builder(MeasurementMade.class).name("queueLength")).triggerChecker(new QueueLengthTriggerChecker(this.trigger, object));
    }

    private <T extends ExpectedValue> T checkExpectedValue(Class<T> expectedType) {
        if (!expectedType.isAssignableFrom(this.trigger.getExpectedValue().getClass())) {
            throw new IllegalArgumentException(String.format("It is only possible that the trigger is of type %s, but the given type was %s", expectedType.getSimpleName(), this.trigger.getExpectedValue().getClass().getSimpleName()));
        }
        return (T)this.trigger.getExpectedValue();
    }
}

