/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities;

import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.targets.TargetGroup;

public final class TargetGroupState {
    private final TargetGroup targetGroup;
    private final List<Double> enactmentTimeOfScalingPolicies = new ArrayList<Double>();
    private final List<ScalingPolicy> enactedScalingPolicies = new ArrayList<ScalingPolicy>();

    public TargetGroupState(TargetGroup target) {
        this.targetGroup = target;
    }

    public TargetGroup getTargetGroup() {
        return this.targetGroup;
    }

    public void addEnactedPolicy(double simulationTime, ScalingPolicy enactedPolicy) {
        this.enactmentTimeOfScalingPolicies.add(simulationTime);
        this.enactedScalingPolicies.add(enactedPolicy);
    }

    public double getLastScalingPolicyEnactmentTime() {
        return (Double)Iterables.getLast(this.enactmentTimeOfScalingPolicies);
    }

    public ScalingPolicy getLastEnactedScalingPolicy() {
        return (ScalingPolicy)Iterables.getLast(this.enactedScalingPolicies);
    }

    public boolean enactedPoliciesEmpty() {
        return Iterables.isEmpty(this.enactedScalingPolicies);
    }
}

