/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter;

import javax.inject.Inject;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SpdBasedEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.SpdInterpreter;
import org.palladiosimulator.analyzer.slingshot.common.annotations.Nullable;
import org.palladiosimulator.analyzer.slingshot.core.api.SimulationDriver;
import org.palladiosimulator.analyzer.slingshot.core.events.PreSimulationConfigurationStarted;
import org.palladiosimulator.analyzer.slingshot.core.extension.SimulationBehaviorExtension;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.Subscribe;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.EventCardinality;
import org.palladiosimulator.analyzer.slingshot.eventdriver.annotations.eventcontract.OnEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.spd.SPD;

@OnEvent(when=PreSimulationConfigurationStarted.class, then={SpdBasedEvent.class}, cardinality=EventCardinality.MANY)
public class SpdBehavior
implements SimulationBehaviorExtension {
    private static final Logger LOGGER = Logger.getLogger(SpdBehavior.class);
    private final SimulationDriver driver;
    private final SPD spdModel;

    @Inject
    public SpdBehavior(SimulationDriver driver, @Nullable SPD spdModel) {
        this.spdModel = spdModel;
        this.driver = driver;
    }

    public boolean isActive() {
        return this.spdModel != null;
    }

    @Subscribe
    public Result<SpdBasedEvent> onPreSimulationConfigurationStarted(PreSimulationConfigurationStarted configurationStarted) {
        SpdInterpreter interpreter = new SpdInterpreter();
        SpdInterpreter.InterpretationResult result = (SpdInterpreter.InterpretationResult)interpreter.doSwitch((EObject)this.spdModel);
        LOGGER.debug((Object)("The result of the SPD interpretation is not null: " + (result != null)));
        result.getAdjustorContexts().stream().peek(ac -> LOGGER.debug((Object)("AdjustorContext: #handlers = " + ac.getAssociatedHandlers().size()))).flatMap(ac -> ac.getAssociatedHandlers().stream()).forEach(arg_0 -> ((SimulationDriver)this.driver).registerEventHandler(arg_0));
        return Result.from(result.getEventsToSchedule());
    }
}

