/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.Filter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.SPDAdjustorState;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;

public class FilterChain {
    protected final List<Filter> filters = new ArrayList<Filter>();
    private final Consumer<Object> doOnDisregard;
    private final SPDAdjustorState state;
    protected Iterator<Filter> iterator;
    private FilterResult latestResult;

    public FilterChain(Consumer<Object> doOnDisregard, SPDAdjustorState state) {
        this.doOnDisregard = Objects.requireNonNull(doOnDisregard);
        this.state = state;
    }

    public FilterChain(SPDAdjustorState state) {
        this(message -> {}, state);
    }

    public void add(Filter filter) {
        this.checkThatChainIsNotCurrentlyUsed();
        this.filters.add(filter);
    }

    public void addAll(Collection<? extends Filter> filters) {
        this.checkThatChainIsNotCurrentlyUsed();
        this.filters.addAll(filters);
    }

    public void add(int i, Filter filter) {
        this.checkThatChainIsNotCurrentlyUsed();
        this.filters.add(i, filter);
    }

    public void next(DESEvent event) {
        if (!this.filterIsBeingUsed()) {
            this.iterator = this.filters.iterator();
        }
        if (this.iterator.hasNext()) {
            try {
                Filter filter = this.iterator.next();
                this.latestResult = filter.doProcess(new FilterObjectWrapper(event, this.state));
            }
            catch (Exception e) {
                this.latestResult = FilterResult.disregard(e);
            }
            this.checkResult();
        } else {
            this.iterator = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void checkResult() {
        void var2_1;
        FilterResult.Success success;
        FilterResult filterResult = this.latestResult;
        if (filterResult instanceof FilterResult.Success && (success = (FilterResult.Success)filterResult) == (FilterResult.Success)var2_1) {
            void success2;
            this.next(success2.nextEvent());
        } else {
             instanceOfPatternExpressionValue = this.latestResult;
            if ( instanceOfPatternExpressionValue instanceof FilterResult.Disregard var3_4) {
                void disregard;
                this.disregard(disregard.reason().toString());
            }
        }
    }

    public FilterResult getLatestResult() {
        return this.latestResult;
    }

    public void disregard(Object message) {
        this.iterator = null;
        this.doOnDisregard.accept(message);
    }

    public boolean filterIsBeingUsed() {
        return this.iterator != null;
    }

    public int size() {
        return this.filters.size();
    }

    private void checkThatChainIsNotCurrentlyUsed() {
        if (this.filterIsBeingUsed()) {
            throw new IllegalStateException("The filter chain is currently in use (next() was called before) or hasn't reached the end yet). Either disregard first or wait until chain has finished.");
        }
    }
}

