/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.adjustor;

import java.util.Optional;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.ModelAdjustmentRequested;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.Filter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.constraints.policy.CooldownConstraint;

public class Adjustor
implements Filter {
    private final ScalingPolicy policy;

    public Adjustor(ScalingPolicy policy) {
        this.policy = policy;
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper objectWrapper) {
        double cooldownTime;
        double currentSimTime = objectWrapper.getEventToFilter().time();
        objectWrapper.getState().setLatestAdjustmentAtSimulationTime(objectWrapper.getEventToFilter().time());
        objectWrapper.getState().incrementNumberScales();
        objectWrapper.getState().getTargetGroupState().addEnactedPolicy(currentSimTime, this.policy);
        Optional<CooldownConstraint> cooldownConstraint = this.policy.getPolicyConstraints().stream().filter(obj -> obj instanceof CooldownConstraint).map(obj -> (CooldownConstraint)obj).findAny();
        if (cooldownConstraint.isPresent() && (cooldownTime = cooldownConstraint.get().getCooldownTime()) != 0.0) {
            if (currentSimTime > objectWrapper.getState().getCoolDownEnd()) {
                objectWrapper.getState().setNumberOfScalesInCooldown(0);
                objectWrapper.getState().setCoolDownEnd(currentSimTime + cooldownTime);
            } else if (currentSimTime == objectWrapper.getState().getCoolDownEnd()) {
                objectWrapper.getState().setCoolDownEnd(currentSimTime + cooldownTime);
            } else {
                objectWrapper.getState().incrementNumberOfAdjustmentsInCooldown();
            }
        }
        return FilterResult.success((DESEvent)new ModelAdjustmentRequested(this.policy));
    }
}

