/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint;

import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.TargetGroupState;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint.AbstractConstraintFilter;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.adjustments.AbsoluteAdjustment;
import org.palladiosimulator.spd.adjustments.AdjustmentType;
import org.palladiosimulator.spd.adjustments.RelativeAdjustment;
import org.palladiosimulator.spd.adjustments.StepAdjustment;
import org.palladiosimulator.spd.constraints.target.ThrashingConstraint;

public final class ThrashingConstraintFilter
extends AbstractConstraintFilter<ThrashingConstraint> {
    public ThrashingConstraintFilter(ThrashingConstraint constraint) {
        super(constraint);
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper event) {
        TargetGroupState targetGroupState = event.getState().getTargetGroupState();
        if (targetGroupState.enactedPoliciesEmpty()) {
            return FilterResult.success(event.getEventToFilter());
        }
        ScalingPolicy lastEnactedPolicy = targetGroupState.getLastEnactedScalingPolicy();
        double lastSimulationTime = targetGroupState.getLastScalingPolicyEnactmentTime();
        double currentSimulationTime = event.getEventToFilter().time();
        ScalingPolicy currentScalingPolicy = event.getState().getScalingPolicy();
        if (currentScalingPolicy.getAdjustmentType() instanceof AbsoluteAdjustment || lastEnactedPolicy.getAdjustmentType() instanceof AbsoluteAdjustment) {
            return FilterResult.success(event.getEventToFilter());
        }
        if (!this.retrieveSign(currentScalingPolicy.getAdjustmentType()).equals((Object)this.retrieveSign(lastEnactedPolicy.getAdjustmentType())) && lastSimulationTime + ((ThrashingConstraint)this.constraint).getMinimumTimeNoThrashing() >= currentSimulationTime) {
            return FilterResult.disregard("Thrashing Constraint prevents this scaling Operation.");
        }
        return FilterResult.success(event.getEventToFilter());
    }

    public ADJUSTMENT_SIGN retrieveSign(AdjustmentType adjustmentType) {
        AdjustmentType adjustmentType2 = adjustmentType;
        if (adjustmentType2 instanceof RelativeAdjustment && (var2_3 = (RelativeAdjustment)adjustmentType2) == (RelativeAdjustment)var3_2) {
            return relativeAdjustment.getPercentageGrowthValue() > 0 ? ADJUSTMENT_SIGN.POSITIVE : ADJUSTMENT_SIGN.NEGATIVE;
        }
        if (adjustmentType instanceof StepAdjustment var4_5) {
            return stepAdjustment.getStepValue() > 0 ? ADJUSTMENT_SIGN.POSITIVE : ADJUSTMENT_SIGN.NEGATIVE;
        }
        return ADJUSTMENT_SIGN.POSITIVE;
    }

    private static enum ADJUSTMENT_SIGN {
        POSITIVE,
        NEGATIVE;

    }
}

