/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger;

import com.google.common.base.Preconditions;
import java.util.Set;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.Filter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.ComparatorResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.ValueComparator;
import org.palladiosimulator.spd.triggers.BaseTrigger;
import org.palladiosimulator.spd.triggers.SimpleFireOnTrend;
import org.palladiosimulator.spd.triggers.SimpleFireOnValue;
import org.palladiosimulator.spd.triggers.expectations.ExpectedPrimitive;
import org.palladiosimulator.spd.triggers.expectations.NoExpectation;
import org.palladiosimulator.spd.triggers.stimuli.Stimulus;

public abstract class TriggerChecker<T extends Stimulus>
implements Filter {
    protected final ValueComparator valueComparator;
    protected final BaseTrigger trigger;
    private final Set<Class<? extends ExpectedPrimitive>> allowedExpectedPrimitives;

    TriggerChecker(BaseTrigger trigger, Class<T> stimulusType, Set<Class<? extends ExpectedPrimitive>> allowedExpectedPrimitives) {
        this.valueComparator = ValueComparator.fromTrigger(trigger);
        this.trigger = trigger;
        this.allowedExpectedPrimitives = allowedExpectedPrimitives;
        Preconditions.checkArgument((boolean)stimulusType.isAssignableFrom(trigger.getStimulus().getClass()), (Object)String.format("Trigger must be of type %s, but is %s", stimulusType.getSimpleName(), trigger.getStimulus().getClass().getSimpleName()));
    }

    protected T getStimulus() {
        return (T)this.trigger.getStimulus();
    }

    protected ComparatorResult compareToTrigger(double value) {
        if (this.trigger instanceof SimpleFireOnValue) {
            if (this.trigger.getExpectedValue() instanceof NoExpectation) {
                return ComparatorResult.IN_ACCORDANCE;
            }
            if (this.allowedExpectedPrimitives.stream().anyMatch(cls -> cls.isAssignableFrom(this.trigger.getExpectedValue().getClass()))) {
                return this.valueComparator.compare(value, this.trigger.getExpectedValue());
            }
            return ComparatorResult.WRONG_EXPECTED_VALUE;
        }
        if (this.trigger instanceof SimpleFireOnTrend) {
            return this.valueComparator.compare(value, this.trigger.getExpectedValue());
        }
        return ComparatorResult.WRONG_TRIGGER;
    }
}

