/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.ui;

import java.util.List;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.core.extension.ModelProvider;
import org.palladiosimulator.analyzer.slingshot.core.extension.PCMResourceSetPartitionProvider;
import org.palladiosimulator.spd.SPD;
import org.palladiosimulator.spd.SpdPackage;

@Singleton
public class SPDModelProvider
implements ModelProvider<SPD> {
    private static final Logger LOGGER = Logger.getLogger(SPDModelProvider.class);
    private final PCMResourceSetPartitionProvider provider;

    @Inject
    public SPDModelProvider(PCMResourceSetPartitionProvider provider) {
        this.provider = provider;
    }

    public SPD get() {
        List spds = this.provider.get().getElement(SpdPackage.eINSTANCE.getSPD());
        if (spds.size() == 0) {
            LOGGER.warn((Object)"An SPD model was not provided. Null will be returned");
            return null;
        }
        return (SPD)spds.get(0);
    }
}

