/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.utils;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.palladiosimulator.analyzer.slingshot.core.Slingshot;
import org.palladiosimulator.pcm.allocation.Allocation;
import org.palladiosimulator.pcm.allocation.AllocationContext;
import org.palladiosimulator.pcm.core.composition.AssemblyContext;
import org.palladiosimulator.pcm.repository.OperationProvidedRole;
import org.palladiosimulator.pcm.repository.OperationSignature;
import org.palladiosimulator.pcm.resourceenvironment.ResourceContainer;
import org.palladiosimulator.semanticspd.CompetingConsumersGroupCfg;
import org.palladiosimulator.semanticspd.Configuration;
import org.palladiosimulator.semanticspd.ElasticInfrastructureCfg;
import org.palladiosimulator.semanticspd.ServiceGroupCfg;
import org.palladiosimulator.semanticspd.TargetGroupCfg;
import org.palladiosimulator.spd.targets.CompetingConsumersGroup;
import org.palladiosimulator.spd.targets.ElasticInfrastructure;
import org.palladiosimulator.spd.targets.ServiceGroup;
import org.palladiosimulator.spd.targets.TargetGroup;

public class TargetGroupUtils {
    private static final Allocation allocation = (Allocation)Slingshot.getInstance().getInstance(Allocation.class);
    private static final Configuration configuration = (Configuration)Slingshot.getInstance().getInstance(Configuration.class);

    public static boolean isContainerInElasticInfrastructure(ResourceContainer container, ElasticInfrastructure targetGroup) {
        List elasticInfraCfgs = configuration.getTargetCfgs().stream().filter(cfg -> {
            TargetGroupCfg targetGroupCfg = cfg;
            boolean bl = targetGroupCfg instanceof ElasticInfrastructureCfg;
            if (bl) {
                void var1_1;
                ElasticInfrastructureCfg elasticInfrastructureCfg = (ElasticInfrastructureCfg)var1_1;
            }
            return bl;
        }).map(c -> (ElasticInfrastructureCfg)c).filter(c -> c.getUnit().getId().equals(targetGroup.getUnit().getId())).collect(Collectors.toList());
        assert (elasticInfraCfgs.size() == 1);
        return ((ElasticInfrastructureCfg)elasticInfraCfgs.get(0)).getElements().stream().anyMatch(rc -> rc.getId().equals(container.getId()));
    }

    public static boolean isContainerInServiceGroup(ResourceContainer container, ServiceGroup serviceGroup) {
        return TargetGroupUtils.isResourceContainerInContextsToConsider(container, () -> TargetGroupUtils.getAllContextsToConsider(serviceGroup));
    }

    public static boolean isContainerInCompetingConsumersGroup(ResourceContainer container, CompetingConsumersGroup competingConsumersGroup) {
        return TargetGroupUtils.isResourceContainerInContextsToConsider(container, () -> TargetGroupUtils.getAllContextsToConsider(competingConsumersGroup));
    }

    public static boolean isContainerInTargetGroup(ResourceContainer container, TargetGroup targetGroup) {
        TargetGroup targetGroup2 = targetGroup;
        if (targetGroup2 instanceof ElasticInfrastructure && (var2_3 = (ElasticInfrastructure)targetGroup2) == (ElasticInfrastructure)var3_2) {
            return TargetGroupUtils.isContainerInElasticInfrastructure(container, (ElasticInfrastructure)elasticInfrastructure);
        }
        if (targetGroup instanceof ServiceGroup var4_5) {
            return TargetGroupUtils.isContainerInServiceGroup(container, (ServiceGroup)serviceGroup);
        }
        if (targetGroup instanceof CompetingConsumersGroup var6_7) {
            return TargetGroupUtils.isContainerInCompetingConsumersGroup(container, (CompetingConsumersGroup)competingConsumersGroup);
        }
        return false;
    }

    public static boolean isAssemblyInTargetGroup(AssemblyContext context, TargetGroup targetGroup) {
        TargetGroup targetGroup2 = targetGroup;
        if (targetGroup2 instanceof ServiceGroup && (var2_3 = (ServiceGroup)targetGroup2) == (ServiceGroup)var3_2) {
            return TargetGroupUtils.getAllContextsToConsider((ServiceGroup)serviceGroup).anyMatch(ac -> ac.getId().equals(context.getId()));
        }
        if (targetGroup instanceof ElasticInfrastructure var4_5) {
            return elasticInfrastructure.getPCM_ResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().anyMatch(rc -> TargetGroupUtils.getContainerRelatedToContext(context).anyMatch(rcp -> rcp.getId().equals(rc.getId())));
        }
        if (targetGroup instanceof CompetingConsumersGroup var6_7) {
            return TargetGroupUtils.getAllContextsToConsider((CompetingConsumersGroup)competingConsumers).anyMatch(ac -> ac.getId().equals(context.getId()));
        }
        return false;
    }

    public static boolean isOperationSinatureRelatedToTargetGroup(OperationSignature operationSignature, TargetGroup targetGroup) {
        TargetGroup targetGroup2 = targetGroup;
        if (targetGroup2 instanceof CompetingConsumersGroup && (var2_3 = (CompetingConsumersGroup)targetGroup2) == (CompetingConsumersGroup)var3_2) {
            return TargetGroupUtils.anyContextHasSignature(TargetGroupUtils.getAllContextsToConsider((CompetingConsumersGroup)competingConsumers), operationSignature);
        }
        if (targetGroup instanceof ServiceGroup var4_5) {
            return TargetGroupUtils.anyContextHasSignature(TargetGroupUtils.getAllContextsToConsider((ServiceGroup)serviceGroup), operationSignature);
        }
        if (targetGroup instanceof ElasticInfrastructure var6_7) {
            return TargetGroupUtils.anyContextHasSignature(TargetGroupUtils.getRelatedAssemblyContextFromInfrastructure((ElasticInfrastructure)infrastructure), operationSignature);
        }
        return false;
    }

    private static Stream<AssemblyContext> getRelatedAssemblyContextFromInfrastructure(ElasticInfrastructure infrastructure) {
        return infrastructure.getPCM_ResourceEnvironment().getResourceContainer_ResourceEnvironment().stream().flatMap(rc -> allocation.getAllocationContexts_Allocation().stream().filter(ac -> ac.getResourceContainer_AllocationContext().getId().equals(rc.getId())).map(AllocationContext::getAssemblyContext_AllocationContext));
    }

    private static boolean anyContextHasSignature(Stream<AssemblyContext> assemblyContexts, OperationSignature operationSignature) {
        return assemblyContexts.map(AssemblyContext::getEncapsulatedComponent__AssemblyContext).flatMap(rc -> rc.getProvidedRoles_InterfaceProvidingEntity().stream()).filter(OperationProvidedRole.class::isInstance).map(OperationProvidedRole.class::cast).flatMap(opr -> opr.getProvidedInterface__OperationProvidedRole().getSignatures__OperationInterface().stream()).anyMatch(sig -> operationSignature.getId().equals(sig.getId()));
    }

    private static Stream<ResourceContainer> getContainerRelatedToContext(AssemblyContext context) {
        return allocation.getAllocationContexts_Allocation().stream().filter(ac -> ac.getAssemblyContext_AllocationContext().getId().equals(context.getId())).map(AllocationContext::getResourceContainer_AllocationContext).flatMap(rc -> rc.getResourceEnvironment_ResourceContainer().getResourceContainer_ResourceEnvironment().stream());
    }

    private static Stream<AssemblyContext> getAllContextsToConsider(ServiceGroup serviceGroup) {
        return configuration.getTargetCfgs().stream().filter(ServiceGroupCfg.class::isInstance).map(ServiceGroupCfg.class::cast).filter(sgc -> sgc.getUnit().getId().equals(serviceGroup.getUnitAssembly().getId())).flatMap(sgc -> sgc.getElements().stream());
    }

    private static Stream<AssemblyContext> getAllContextsToConsider(CompetingConsumersGroup competingConsumersGroup) {
        return configuration.getTargetCfgs().stream().filter(CompetingConsumersGroupCfg.class::isInstance).map(CompetingConsumersGroupCfg.class::cast).filter(ccgc -> ccgc.getUnit().getId().equals(competingConsumersGroup.getUnitAssembly().getId())).flatMap(ccgc -> Stream.concat(Stream.of(ccgc.getBrokerAssembly()), ccgc.getElements().stream()));
    }

    private static boolean isResourceContainerInContextsToConsider(ResourceContainer container, Supplier<Stream<AssemblyContext>> contextsToConsider) {
        return allocation.getAllocationContexts_Allocation().stream().filter(ac -> ((Stream)contextsToConsider.get()).anyMatch(asc -> ac.getAssemblyContext_AllocationContext().getId().equals(asc.getId()))).map(AllocationContext::getResourceContainer_AllocationContext).anyMatch(rc -> rc.getId().equals(container.getId()));
    }
}

