/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator;

import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Queue;
import java.util.function.Function;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.AbstractWindowAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.functions.MaxAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.functions.MeanAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.functions.MedianAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.functions.MinAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.functions.SumAggregation;
import org.palladiosimulator.spd.triggers.AGGREGATIONMETHOD;

public class FixedLengthWindowSimpleAggregation
extends AbstractWindowAggregation {
    public static final int DEFAULT_WINDOW_SIZE = 10;
    protected final int windowSize;
    protected final Queue<Double> valuesToConsider;
    private double currentValue;
    private final Function<Collection<Double>, Double> aggrFunction;

    private FixedLengthWindowSimpleAggregation(int windowSize, Function<Collection<Double>, Double> aggrFunction) {
        this.windowSize = windowSize;
        this.valuesToConsider = new ArrayDeque<Double>(windowSize);
        this.aggrFunction = aggrFunction;
    }

    @Override
    public final double aggregate(double time, double newValue) {
        this.consider(newValue);
        this.currentValue = this.aggrFunction.apply(this.valuesToConsider);
        return this.currentValue;
    }

    @Override
    public boolean isEmittable() {
        return this.valuesToConsider.size() == this.windowSize;
    }

    private void consider(double newValue) {
        if (this.valuesToConsider.size() == this.windowSize) {
            this.valuesToConsider.poll();
        }
        this.valuesToConsider.offer(newValue);
    }

    public static FixedLengthWindowSimpleAggregation getFromAggregationMethod(AGGREGATIONMETHOD aggregationMethod, int windowSize) {
        return switch (aggregationMethod) {
            case AGGREGATIONMETHOD.MIN -> new FixedLengthWindowSimpleAggregation(windowSize, new MinAggregation());
            case AGGREGATIONMETHOD.AVERAGE -> new FixedLengthWindowSimpleAggregation(windowSize, new MeanAggregation());
            case AGGREGATIONMETHOD.MAX -> new FixedLengthWindowSimpleAggregation(windowSize, new MaxAggregation());
            case AGGREGATIONMETHOD.MEDIAN -> new FixedLengthWindowSimpleAggregation(windowSize, new MedianAggregation());
            case AGGREGATIONMETHOD.SUM -> new FixedLengthWindowSimpleAggregation(windowSize, new SumAggregation());
            default -> throw new IllegalArgumentException("Unexpected value: " + aggregationMethod);
        };
    }

    public static FixedLengthWindowSimpleAggregation getFromAggregationMethod(AGGREGATIONMETHOD aggregationMethod) {
        return FixedLengthWindowSimpleAggregation.getFromAggregationMethod(aggregationMethod, 10);
    }

    public final int getSize() {
        return this.valuesToConsider.size();
    }

    @Override
    protected double getCurrentVal() {
        return this.currentValue;
    }
}

