/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger;

import java.util.Set;
import javax.measure.Measure;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.FixedLengthWindowSimpleAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.SlidingTimeWindowAggregationBasedOnEMA;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.WindowAggregation;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.ComparatorResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.trigger.TriggerChecker;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.monitor.data.entities.SlingshotMeasuringValue;
import org.palladiosimulator.analyzer.slingshot.monitor.data.events.MeasurementMade;
import org.palladiosimulator.metricspec.BaseMetricDescription;
import org.palladiosimulator.metricspec.MetricDescription;
import org.palladiosimulator.metricspec.MetricSetDescription;
import org.palladiosimulator.metricspec.constants.MetricDescriptionConstants;
import org.palladiosimulator.spd.targets.TargetGroup;
import org.palladiosimulator.spd.triggers.AGGREGATIONMETHOD;
import org.palladiosimulator.spd.triggers.BaseTrigger;
import org.palladiosimulator.spd.triggers.expectations.ExpectedPrimitive;
import org.palladiosimulator.spd.triggers.stimuli.ManagedElementsStateStimulus;

public abstract class AbstractManagedElementTriggerChecker<T extends ManagedElementsStateStimulus>
extends TriggerChecker<T> {
    protected final TargetGroup targetGroup;
    protected final T managedElementsStateStimulus;
    protected final MetricSetDescription metricSetDescription;
    protected final BaseMetricDescription baseMetricDescription;
    protected final WindowAggregation aggregator;

    public AbstractManagedElementTriggerChecker(BaseTrigger trigger, T stimulus, TargetGroup targetGroup, Set<Class<? extends ExpectedPrimitive>> allowedExpectedPrimitives, MetricSetDescription metricSetDescription, BaseMetricDescription baseMetricDescription) {
        super(trigger, stimulus.getClass(), allowedExpectedPrimitives);
        this.targetGroup = targetGroup;
        this.managedElementsStateStimulus = stimulus;
        this.metricSetDescription = metricSetDescription;
        this.baseMetricDescription = baseMetricDescription;
        this.aggregator = stimulus.getAggregationOverElements().equals((Object)AGGREGATIONMETHOD.AVERAGE) ? new SlidingTimeWindowAggregationBasedOnEMA(60, 10.0, 0.2) : FixedLengthWindowSimpleAggregation.getFromAggregationMethod(stimulus.getAggregationOverElements());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public FilterResult doProcess(FilterObjectWrapper event) {
        void var3_2;
        MeasurementMade measurementMade;
        DESEvent dESEvent = event.getEventToFilter();
        if (dESEvent instanceof MeasurementMade && (measurementMade = (MeasurementMade)dESEvent) == (MeasurementMade)var3_2) {
            void measurementMade2;
            this.aggregateMeasurement((MeasurementMade)measurementMade2);
            return this.getResult((DESEvent)measurementMade2);
        }
        return FilterResult.disregard("Not a measurement made event.");
    }

    protected FilterResult getResult(DESEvent event) {
        if (!this.aggregator.isEmittable()) {
            return FilterResult.disregard("Values not emittable.");
        }
        double aggregatedValue = this.aggregator.getCurrentValue();
        if (this.compareToTrigger(aggregatedValue) == ComparatorResult.IN_ACCORDANCE) {
            return FilterResult.success(event);
        }
        return FilterResult.disregard("Value and Expectation not in accordance.");
    }

    protected void aggregateMeasurement(MeasurementMade measurementMade) {
        if (((SlingshotMeasuringValue)measurementMade.getEntity()).getMetricDesciption().getId().equals(this.metricSetDescription.getId())) {
            this.aggregator.aggregate(this.getPointInTime((SlingshotMeasuringValue)measurementMade.getEntity()), this.getValueForAggregation((SlingshotMeasuringValue)measurementMade.getEntity()));
        }
    }

    protected double getPointInTime(SlingshotMeasuringValue smv) {
        Measure pointInTime = smv.getMeasureForMetric((MetricDescription)MetricDescriptionConstants.POINT_IN_TIME_METRIC);
        double value = (Double)pointInTime.getValue();
        return value;
    }

    protected double getValueForAggregation(SlingshotMeasuringValue smv) {
        Measure measure = smv.getMeasureForMetric((MetricDescription)this.baseMetricDescription);
        double value = (Double)measure.getValue();
        return value;
    }
}

