/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.EObject;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.data.SpdBasedEvent;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.ScalingTriggerInterpreter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.SPDAdjustorContext;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.TargetGroupState;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.spd.SPD;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.targets.TargetGroup;
import org.palladiosimulator.spd.util.SpdSwitch;

class SpdInterpreter
extends SpdSwitch<InterpretationResult> {
    private static final Logger LOGGER = Logger.getLogger(SpdInterpreter.class);
    private final Map<TargetGroup, TargetGroupState> targetGroupStates = new HashMap<TargetGroup, TargetGroupState>();

    SpdInterpreter() {
    }

    public InterpretationResult caseSPD(SPD spd) {
        LOGGER.debug((Object)("Interpreting SPD Model " + spd.getEntityName() + "[" + spd.getId() + "]"));
        spd.getTargetGroups().stream().forEach(target -> {
            TargetGroupState targetGroupState = this.targetGroupStates.put((TargetGroup)target, new TargetGroupState((TargetGroup)target));
        });
        return spd.getScalingPolicies().stream().map(arg_0 -> ((SpdInterpreter)this).doSwitch(arg_0)).reduce(InterpretationResult::add).orElseGet(() -> InterpretationResult.EMPTY_RESULT);
    }

    public InterpretationResult caseScalingPolicy(ScalingPolicy policy) {
        LOGGER.debug((Object)("Interpreting ScalingPolicy Model " + policy.getEntityName() + "[" + policy.getId() + "]"));
        if (!policy.isActive()) {
            return new InterpretationResult();
        }
        ScalingTriggerInterpreter.InterpretationResult intrResult = (ScalingTriggerInterpreter.InterpretationResult)new ScalingTriggerInterpreter(policy).doSwitch((EObject)policy.getScalingTrigger());
        return new InterpretationResult().adjustorContext(new SPDAdjustorContext(policy, intrResult.getTriggerChecker(), intrResult.getEventsToListen(), this.targetGroupStates.get(policy.getTargetGroup()))).eventsToSchedule(intrResult.getEventsToSchedule());
    }

    public static final class InterpretationResult {
        public static final InterpretationResult EMPTY_RESULT = new InterpretationResult();
        private final List<SPDAdjustorContext> adjustorContexts;
        private final List<SpdBasedEvent> eventsToSchedule;
        private final List<Subscriber<? extends DESEvent>> subscribers;

        InterpretationResult() {
            this.adjustorContexts = new ArrayList<SPDAdjustorContext>();
            this.eventsToSchedule = new ArrayList<SpdBasedEvent>();
            this.subscribers = new ArrayList<Subscriber<? extends DESEvent>>();
        }

        InterpretationResult(List<SPDAdjustorContext> adjustorContexts, List<SpdBasedEvent> eventsToSchedule, List<Subscriber<? extends DESEvent>> subscribers) {
            this.adjustorContexts = new ArrayList<SPDAdjustorContext>(adjustorContexts);
            this.eventsToSchedule = new ArrayList<SpdBasedEvent>(eventsToSchedule);
            this.subscribers = new ArrayList<Subscriber<? extends DESEvent>>(subscribers);
        }

        InterpretationResult(InterpretationResult other) {
            this(other.adjustorContexts, other.eventsToSchedule, other.subscribers);
        }

        public InterpretationResult adjustorContext(SPDAdjustorContext adjustorContext) {
            this.adjustorContexts.add(adjustorContext);
            return this;
        }

        public InterpretationResult adjustorContext(Collection<? extends SPDAdjustorContext> adjustorContexts) {
            this.adjustorContexts.addAll(adjustorContexts);
            return this;
        }

        public InterpretationResult eventsToSchedule(Collection<? extends SpdBasedEvent> eventsToSchedule) {
            this.eventsToSchedule.addAll(eventsToSchedule);
            return this;
        }

        public List<SPDAdjustorContext> getAdjustorContexts() {
            return this.adjustorContexts;
        }

        public List<SpdBasedEvent> getEventsToSchedule() {
            return this.eventsToSchedule;
        }

        public List<Subscriber<? extends DESEvent>> getSubscribers() {
            return this.subscribers;
        }

        public InterpretationResult add(InterpretationResult other) {
            this.adjustorContexts.addAll(other.adjustorContexts);
            this.eventsToSchedule.addAll(other.eventsToSchedule);
            return this;
        }
    }
}

