/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities;

import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.log4j.Logger;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.Filter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterChain;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.SPDAdjustorState;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.TargetGroupState;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.adjustor.Adjustor;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint.AbstractConstraintFilter;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.targetgroup.TargetGroupChecker;
import org.palladiosimulator.analyzer.slingshot.common.events.DESEvent;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.EventHandler;
import org.palladiosimulator.analyzer.slingshot.eventdriver.entity.Subscriber;
import org.palladiosimulator.analyzer.slingshot.eventdriver.returntypes.Result;
import org.palladiosimulator.spd.ScalingPolicy;
import org.palladiosimulator.spd.constraints.AbstractConstraint;
import org.palladiosimulator.spd.constraints.target.TargetConstraint;
import org.palladiosimulator.spd.constraints.target.ThrashingConstraint;

public final class SPDAdjustorContext {
    private static final Logger LOGGER = Logger.getLogger(SPDAdjustorContext.class);
    private final FilterChain filterChain;
    private final ScalingPolicy scalingPolicy;
    private final Set<Subscriber<? extends DESEvent>> associatedHandlers;
    private SPDAdjustorState state;
    private final SPDAdjustorState previousState;

    public SPDAdjustorContext(ScalingPolicy policy, Filter triggerChecker, List<Subscriber.Builder<? extends DESEvent>> associatedHandlers, TargetGroupState targetGroupState) {
        this.scalingPolicy = policy;
        this.state = new SPDAdjustorState(policy, targetGroupState);
        this.previousState = new SPDAdjustorState(policy, targetGroupState);
        this.filterChain = new FilterChain(this::doOnDisregard, this.state);
        this.initializeFilterChain(triggerChecker);
        PublishResultingEventFilter publisher = new PublishResultingEventFilter();
        this.associatedHandlers = associatedHandlers.stream().map(builder -> builder.handler((EventHandler)publisher)).map(builder -> builder.build()).collect(Collectors.toSet());
    }

    private void initializeFilterChain(Filter triggerChecker) {
        this.filterChain.add(new TargetGroupChecker(this.scalingPolicy.getTargetGroup()));
        this.filterChain.add(triggerChecker);
        this.scalingPolicy.getTargetGroup().getTargetConstraints().stream().filter(constraint -> {
            TargetConstraint targetConstraint = constraint;
            boolean bl = targetConstraint instanceof ThrashingConstraint;
            if (bl) {
                void var1_1;
                ThrashingConstraint thrashingConstraint = (ThrashingConstraint)var1_1;
            }
            return bl;
        }).map(constraint -> (ThrashingConstraint)constraint).forEach(constraint -> this.filterChain.add(AbstractConstraintFilter.createAbstractConstraintFilter((AbstractConstraint)constraint)));
        this.scalingPolicy.getPolicyConstraints().forEach(constraint -> this.filterChain.add(AbstractConstraintFilter.createAbstractConstraintFilter((AbstractConstraint)constraint)));
        this.filterChain.add(new Adjustor(this.scalingPolicy));
    }

    public FilterChain getFilterChain() {
        return this.filterChain;
    }

    public ScalingPolicy getScalingPolicy() {
        return this.scalingPolicy;
    }

    public Collection<Subscriber<? extends DESEvent>> getAssociatedHandlers() {
        return this.associatedHandlers;
    }

    private void doOnDisregard(Object reason) {
        this.state = this.previousState;
        LOGGER.info((Object)("Filter was not successful: " + reason.toString()));
    }

    public int hashCode() {
        return Objects.hash(this.scalingPolicy.getId());
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(Object other) {
        void var3_2;
        SPDAdjustorContext sPDAdjustorContext;
        if (this == other) {
            return true;
        }
        Object object = other;
        if (object instanceof SPDAdjustorContext && (sPDAdjustorContext = (SPDAdjustorContext)object) == (SPDAdjustorContext)var3_2) {
            void otherContext;
            return Objects.equals(this.scalingPolicy.getId(), otherContext.scalingPolicy.getId());
        }
        return false;
    }

    private class PublishResultingEventFilter
    implements EventHandler<DESEvent> {
        private PublishResultingEventFilter() {
        }

        /*
         * WARNING - void declaration
         */
        public Result<?> acceptEvent(DESEvent event) throws Exception {
            FilterResult filterResult;
            SPDAdjustorContext.this.filterChain.next(event);
            FilterResult filterResult2 = filterResult = SPDAdjustorContext.this.filterChain.getLatestResult();
            if (filterResult2 instanceof FilterResult.Success var3_4) {
                void success;
                DESEvent result = success.nextEvent();
                LOGGER.debug((Object)("Got a result after filtering! " + result.getClass().getSimpleName()));
                return Result.of((Object[])new Object[]{result});
            }
            return Result.empty();
        }
    }
}

