/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator;

import java.util.Collection;
import java.util.Deque;
import java.util.LinkedList;
import java.util.function.Function;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.aggregator.AbstractWindowAggregation;

public class SlidingTimeWindowAggregation
extends AbstractWindowAggregation {
    private Deque<DataPoint> window = new LinkedList<DataPoint>();
    private double windowSizeInSeconds;
    private double currentSum;
    private double emitTime;
    private final double durationNoEmit;
    private final Function<Collection<Double>, Double> aggregationFunction;

    public SlidingTimeWindowAggregation(int winSizeSeconds, double noEmitDuration, Function<Collection<Double>, Double> aggrFunction) {
        this.windowSizeInSeconds = winSizeSeconds;
        this.currentSum = 0.0;
        this.durationNoEmit = noEmitDuration;
        this.emitTime = 0.0;
        this.aggregationFunction = aggrFunction;
    }

    @Override
    public boolean isEmittable() {
        return this.window.getLast().timestamp > this.windowSizeInSeconds && this.window.getLast().timestamp - this.emitTime > this.durationNoEmit;
    }

    @Override
    public double aggregate(double time, double newValue) {
        while (!this.window.isEmpty() && this.window.getFirst().timestamp <= time - this.windowSizeInSeconds) {
            DataPoint removed = this.window.removeFirst();
            this.currentSum -= removed.value;
        }
        DataPoint newPoint = new DataPoint(time, newValue);
        this.window.addLast(newPoint);
        this.currentSum += newValue;
        return this.currentSum / (double)this.window.size();
    }

    @Override
    protected double getCurrentVal() {
        this.emitTime = this.window.getLast().timestamp;
        return this.aggregationFunction.apply(this.window.stream().map(dp -> dp.value).toList());
    }

    private class DataPoint {
        double timestamp;
        double value;

        DataPoint(double timestamp, double value) {
            this.timestamp = timestamp;
            this.value = value;
        }
    }
}

