/*
 * Decompiled with CFR 0.152.
 */
package org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint;

import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterObjectWrapper;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entities.FilterResult;
import org.palladiosimulator.analyzer.slingshot.behavior.spd.interpreter.entity.constraint.AbstractConstraintFilter;
import org.palladiosimulator.spd.constraints.policy.IntervalConstraint;

public class IntervalConstraintFilter
extends AbstractConstraintFilter<IntervalConstraint> {
    private final double delta;
    private final boolean repeat;

    public IntervalConstraintFilter(IntervalConstraint constraint) {
        super(constraint);
        this.delta = constraint.getOffset() + constraint.getIntervalDuration();
        this.repeat = constraint.isRepeat();
    }

    @Override
    public FilterResult doProcess(FilterObjectWrapper event) {
        double currentSimulationTime = event.getEventToFilter().time();
        if (!this.isWithinInterval(currentSimulationTime)) {
            return FilterResult.success(event.getEventToFilter());
        }
        return FilterResult.disregard(this.getErrorMessage(currentSimulationTime));
    }

    private boolean isWithinInterval(double simulationTime) {
        return this.repeat && simulationTime != 0.0 && (simulationTime % this.delta == 0.0 || simulationTime % this.delta >= ((IntervalConstraint)this.constraint).getOffset()) || !this.repeat && simulationTime >= ((IntervalConstraint)this.constraint).getOffset() && simulationTime <= this.delta;
    }

    private String getErrorMessage(double simulationTime) {
        if (this.repeat) {
            return String.format("The simulation time is inside of the interval or zero: %f in [%f, %f]", simulationTime % this.delta, ((IntervalConstraint)this.constraint).getOffset(), this.delta);
        }
        return String.format("The simulation time is inside of the interval: %f in [%f, %f]", simulationTime, ((IntervalConstraint)this.constraint).getOffset(), this.delta);
    }
}

